/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.lang.invoke.MethodHandles;
import org.hibernate.FetchNotFoundException;
import org.hibernate.LockMode;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.sql.results.graph.entity.ReactiveAbstractEntityInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ReactiveEntityJoinedFetchInitializer
extends ReactiveAbstractEntityInitializer {
    private static final String CONCRETE_NAME = ReactiveEntityJoinedFetchInitializer.class.getSimpleName();
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final EntityValuedFetchable referencedFetchable;
    private final DomainResultAssembler<?> keyAssembler;
    private final NotFoundAction notFoundAction;
    private final boolean isEnhancedForLazyLoading;

    public ReactiveEntityJoinedFetchInitializer(EntityResultGraphNode resultDescriptor, EntityValuedFetchable referencedFetchable, NavigablePath navigablePath, LockMode lockMode, NotFoundAction notFoundAction, DomainResult<?> keyResult, DomainResult<Object> rowIdResult, Fetch identifierFetch, Fetch discriminatorFetch, AssemblerCreationState creationState) {
        super(resultDescriptor, navigablePath, lockMode, identifierFetch, discriminatorFetch, rowIdResult, creationState);
        this.referencedFetchable = referencedFetchable;
        this.notFoundAction = notFoundAction;
        this.keyAssembler = keyResult == null ? null : keyResult.createResultAssembler((FetchParentAccess)this, creationState);
        this.isEnhancedForLazyLoading = this.getConcreteDescriptor() != null ? this.getConcreteDescriptor().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() : false;
    }

    protected void registerLoadingEntityInstanceFromExecutionContext(RowProcessingState rowProcessingState, Object instance) {
    }

    public void resolveKey(RowProcessingState rowProcessingState) {
        Object fkKeyValue;
        if (this.shouldSkipResolveInstance(rowProcessingState)) {
            this.missing = true;
            return;
        }
        super.resolveKey(rowProcessingState);
        if (this.keyAssembler != null && (fkKeyValue = this.keyAssembler.assemble(rowProcessingState)) != null && this.isMissing()) {
            if (this.notFoundAction != NotFoundAction.IGNORE) {
                throw new FetchNotFoundException(this.referencedFetchable.getEntityMappingType().getEntityName(), fkKeyValue);
            }
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("Ignoring dangling foreign-key due to `@NotFound(IGNORE); association will be null - %s", (Object)this.getNavigablePath());
        }
    }

    protected Object getProxy(PersistenceContext persistenceContext) {
        ModelPart referencedModelPart = this.getInitializedPart();
        if (referencedModelPart instanceof ToOneAttributeMapping) {
            boolean unwrapProxy;
            boolean bl = unwrapProxy = ((ToOneAttributeMapping)referencedModelPart).isUnwrapProxy() && this.isEnhancedForLazyLoading;
            if (unwrapProxy) {
                return null;
            }
        }
        return super.getProxy(persistenceContext);
    }

    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    protected boolean isEntityReturn() {
        return false;
    }
}

