/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntitySelectFetchInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ReactiveEntitySelectFetchByUniqueKeyInitializer
extends ReactiveEntitySelectFetchInitializer {
    private final ToOneAttributeMapping fetchedAttribute;

    public ReactiveEntitySelectFetchByUniqueKeyInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping fetchedAttribute, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> keyAssembler) {
        super(parentAccess, fetchedAttribute, fetchedNavigable, concreteDescriptor, keyAssembler);
        this.fetchedAttribute = fetchedAttribute;
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(ReactiveRowProcessingState rowProcessingState) {
        if (this.entityInstance != null || this.isInitialized) {
            return CompletionStages.voidFuture();
        }
        EntityInitializer parentEntityInitializer = this.getParentEntityInitializer(this.parentAccess);
        if (parentEntityInitializer != null && parentEntityInitializer.getEntityKey() != null) {
            parentEntityInitializer.resolveInstance((RowProcessingState)rowProcessingState);
            if (parentEntityInitializer.isEntityInitialized()) {
                this.isInitialized = true;
                return CompletionStages.voidFuture();
            }
        }
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            this.isInitialized = true;
            return CompletionStages.voidFuture();
        }
        Object entityIdentifier = this.keyAssembler.assemble((RowProcessingState)rowProcessingState);
        if (entityIdentifier == null) {
            this.isInitialized = true;
            return CompletionStages.voidFuture();
        }
        String entityName = this.concreteDescriptor.getEntityName();
        String uniqueKeyPropertyName = this.fetchedAttribute.getReferencedPropertyName();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, entityIdentifier, this.concreteDescriptor.getPropertyType(uniqueKeyPropertyName), session.getFactory());
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        this.setEntityInstance(persistenceContext.getEntity(euk));
        if (this.entityInstance == null) {
            ReactiveEntitySelectFetchByUniqueKeyInitializer initializer = (ReactiveEntitySelectFetchByUniqueKeyInitializer)persistenceContext.getLoadContexts().findInitializer(euk);
            if (initializer == null) {
                JdbcValuesSourceProcessingState jdbcValuesSourceProcessingState = rowProcessingState.getJdbcValuesSourceProcessingState();
                jdbcValuesSourceProcessingState.registerInitializer(euk, (Initializer)this);
                return ((ReactiveEntityPersister)this.concreteDescriptor).reactiveLoadByUniqueKey(uniqueKeyPropertyName, entityIdentifier, session).thenAccept(this::setEntityInstance).thenAccept(v -> {
                    if (this.entityInstance != null) {
                        persistenceContext.addEntity(euk, this.entityInstance);
                    }
                    this.notifyResolutionListeners(this.entityInstance);
                });
            }
            this.registerResolutionListener(this::setEntityInstance);
        }
        if (this.entityInstance != null) {
            this.setEntityInstance(persistenceContext.proxyFor(this.entityInstance));
        }
        this.isInitialized = true;
        return CompletionStages.voidFuture();
    }

    private EntityInitializer getParentEntityInitializer(FetchParentAccess parentAccess) {
        if (parentAccess != null) {
            return parentAccess.findFirstEntityInitializer();
        }
        return null;
    }

    private void setEntityInstance(Object instance) {
        this.entityInstance = instance;
    }
}

