/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.type.descriptor.jdbc;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.ByteArrayJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectJdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterArray;
import org.hibernate.type.spi.TypeConfiguration;

public class ReactiveArrayJdbcType
implements JdbcType {
    public static final ReactiveArrayJdbcType INSTANCE = new ReactiveArrayJdbcType((JdbcType)ObjectJdbcType.INSTANCE);
    private final JdbcType elementJdbcType;

    public ReactiveArrayJdbcType(JdbcType elementJdbcType) {
        this.elementJdbcType = elementJdbcType;
    }

    public int getJdbcTypeCode() {
        return 2003;
    }

    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        JavaType elementJavaType = this.elementJdbcType.getJdbcRecommendedJavaTypeMapping(precision, scale, typeConfiguration);
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(Array.newInstance(elementJavaType.getJavaTypeClass(), 0).getClass());
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        Object elementJavaType = javaTypeDescriptor instanceof ByteArrayJavaType ? ByteJavaType.INSTANCE : ((BasicPluralJavaType)javaTypeDescriptor).getElementJavaType();
        JdbcLiteralFormatter elementFormatter = this.elementJdbcType.getJdbcLiteralFormatter((JavaType)elementJavaType);
        return new JdbcLiteralFormatterArray(javaTypeDescriptor, elementFormatter);
    }

    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return java.sql.Array.class;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, value);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) {
                try {
                    st.setObject(name, value);
                }
                catch (SQLException ex) {
                    throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", (Throwable)ex);
                }
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)rs.getArray(paramIndex), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getArray(index), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)statement.getArray(name), options);
            }
        };
    }

    public String getFriendlyName() {
        return "ARRAY";
    }

    public String toString() {
        return ReactiveArrayJdbcType.class.getSimpleName() + "(" + this.getFriendlyName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactiveArrayJdbcType that = (ReactiveArrayJdbcType)o;
        return this.elementJdbcType.equals(that.elementJdbcType);
    }

    public int hashCode() {
        return this.elementJdbcType.hashCode();
    }
}

