/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.ComparableExecutable;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.util.impl.CompletionStages;

public interface ReactiveEntityInsertAction
extends ReactiveExecutable,
ComparableExecutable {
    public boolean isEarlyInsert();

    public NonNullableTransientDependencies findNonNullableTransientEntities();

    public SharedSessionContractImplementor getSession();

    public boolean isVeto();

    public Object getInstance();

    public String getEntityName();

    public Object[] getState();

    public Object getRowId();

    public EntityPersister getPersister();

    public boolean isExecuted();

    public boolean isVersionIncrementDisabled();

    public boolean areTransientReferencesNullified();

    public void setTransientReferencesNullified();

    public EntityKey getEntityKey();

    default public CompletionStage<Void> reactiveNullifyTransientReferencesIfNotAlready() {
        if (!this.areTransientReferencesNullified()) {
            return new ForeignKeys.Nullifier(this.getInstance(), false, this.isEarlyInsert(), (SessionImplementor)this.getSession(), this.getPersister()).nullifyTransientReferences(this.getState()).thenAccept(v -> {
                new Nullability(this.getSession()).checkNullability(this.getState(), this.getPersister(), false);
                this.setTransientReferencesNullified();
            });
        }
        return CompletionStages.voidFuture();
    }

    default public CompletionStage<Void> reactiveMakeEntityManaged() {
        return this.reactiveNullifyTransientReferencesIfNotAlready().thenAccept(v -> {
            Object version = Versioning.getVersion((Object[])this.getState(), (EntityPersister)this.getPersister());
            PersistenceContext persistenceContextInternal = this.getSession().getPersistenceContextInternal();
            EntityHolder entityHolder = persistenceContextInternal.addEntityHolder(this.getEntityKey(), this.getInstance());
            EntityEntry entityEntry = persistenceContextInternal.addEntry(this.getInstance(), this.getPersister().isMutable() ? Status.MANAGED : Status.READ_ONLY, this.getState(), this.getRowId(), this.getEntityKey().getIdentifier(), version, LockMode.WRITE, this.isExecuted(), this.getPersister(), this.isVersionIncrementDisabled());
            entityHolder.setEntityEntry(entityEntry);
            if (this.isEarlyInsert()) {
                this.addCollectionsByKeyToPersistenceContext(persistenceContextInternal, this.getState());
            }
        });
    }

    public void addCollectionsByKeyToPersistenceContext(PersistenceContext var1, Object[] var2);

    default public CompletionStage<NonNullableTransientDependencies> reactiveFindNonNullableTransientEntities() {
        return ForeignKeys.findNonNullableTransientEntities(this.getPersister().getEntityName(), this.getInstance(), this.getState(), this.isEarlyInsert(), this.getSession());
    }

    public AbstractEntityInsertAction asAbstractEntityInsertAction();
}

