/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.mutation.internal;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorSingleSelfExecuting;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.sql.model.ReactiveSelfExecutingUpdateOperation;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;
import org.hibernate.sql.model.ValuesAnalysis;

public class ReactiveMutationExecutorSingleSelfExecuting
extends MutationExecutorSingleSelfExecuting
implements ReactiveMutationExecutor {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final SelfExecutingUpdateOperation operation;

    public ReactiveMutationExecutorSingleSelfExecuting(SelfExecutingUpdateOperation operation, SharedSessionContractImplementor session) {
        super(operation, session);
        this.operation = operation;
    }

    protected void performSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("performReactiveSelfExecutingOperation");
    }

    @Override
    public CompletionStage<Void> performReactiveSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        if (inclusionChecker.include(this.operation.getTableDetails()) && this.operation instanceof ReactiveSelfExecutingUpdateOperation) {
            return ((ReactiveSelfExecutingUpdateOperation)this.operation).performReactiveMutation(this.getJdbcValueBindings(), valuesAnalysis, session);
        }
        return CompletionStages.voidFuture();
    }
}

