/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.TransientObjectException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LockEvent;
import org.hibernate.event.spi.LockEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.engine.impl.ReactiveEntityIncrementVersionProcess;
import org.hibernate.reactive.engine.impl.ReactiveEntityVerifyVersionProcess;
import org.hibernate.reactive.event.ReactiveLockEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;

public class DefaultReactiveLockEventListener
extends AbstractReassociateEventListener
implements LockEventListener,
ReactiveLockEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    @Override
    public CompletionStage<Void> reactiveOnLock(LockEvent event) throws HibernateException {
        boolean detached;
        if (event.getObject() == null) {
            throw new NullPointerException("attempted to lock null");
        }
        if (event.getLockMode() == LockMode.WRITE) {
            throw LOG.invalidLockModeForLock();
        }
        if (event.getLockMode() == LockMode.UPGRADE_SKIPLOCKED) {
            LOG.explicitSkipLockedLockCombo();
        }
        EventSource source = event.getSession();
        boolean bl = event.getEntityName() != null ? !source.contains(event.getEntityName(), event.getObject()) : (detached = !source.contains(event.getObject()));
        if (detached) {
            throw new IllegalArgumentException("unmanaged instance passed to refresh()");
        }
        return ((ReactiveSession)source).reactiveFetch(event.getObject(), true).thenCompose(entity -> this.reactiveOnLock(event, entity));
    }

    private CompletionStage<Void> reactiveOnLock(LockEvent event, Object entity) {
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        return this.lockEntry(event, entity, entry, (SessionImplementor)source).thenCompose(e -> this.upgradeLock(entity, (EntityEntry)e, event.getLockOptions(), event.getSession()));
    }

    private CompletionStage<EntityEntry> lockEntry(LockEvent event, Object entity, EntityEntry entry, SessionImplementor source) {
        if (entry == null) {
            EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
            Object id = persister.getIdentifier(entity, (SharedSessionContractImplementor)source);
            return ForeignKeys.isNotTransient(event.getEntityName(), entity, Boolean.FALSE, source).thenCompose(trans -> {
                if (!trans.booleanValue()) {
                    return CompletionStages.failedFuture((Throwable)new TransientObjectException("cannot lock an unsaved transient instance: " + persister.getEntityName()));
                }
                EntityEntry e = this.reassociate((AbstractEvent)event, entity, id, persister);
                return this.cascadeOnLock(event, persister, entity).thenApply(v -> e);
            });
        }
        return CompletionStages.completedFuture(entry);
    }

    private CompletionStage<Void> cascadeOnLock(LockEvent event, EntityPersister persister, Object entity) {
        return Cascade.cascade(CascadingActions.LOCK, CascadePoint.AFTER_LOCK, event.getSession(), persister, entity, event.getLockOptions());
    }

    protected CompletionStage<Void> upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource source) {
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (requestedLockMode.greaterThan(entry.getLockMode())) {
            if (entry.getStatus() != Status.MANAGED) {
                throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getPersister().getEntityName());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Locking {0} in mode: {1}", MessageHelper.infoString((EntityPersister)entry.getPersister(), (Object)entry.getId(), (SessionFactoryImplementor)source.getFactory()), requestedLockMode);
            }
            ReactiveActionQueue actionQueue = ((ReactiveSession)source).getReactiveActionQueue();
            switch (requestedLockMode) {
                case OPTIMISTIC: {
                    actionQueue.registerProcess(new ReactiveEntityVerifyVersionProcess(object));
                    entry.setLockMode(requestedLockMode);
                    return CompletionStages.voidFuture();
                }
                case OPTIMISTIC_FORCE_INCREMENT: {
                    actionQueue.registerProcess(new ReactiveEntityIncrementVersionProcess(object));
                    entry.setLockMode(requestedLockMode);
                    return CompletionStages.voidFuture();
                }
            }
            return this.doUpgradeLock(object, entry, lockOptions, source);
        }
        return CompletionStages.voidFuture();
    }

    private CompletionStage<Void> doUpgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource source) {
        SoftLock lock;
        Object cacheKey;
        EntityPersister persister = entry.getPersister();
        boolean canWriteToCache = persister.canWriteToCache();
        if (canWriteToCache) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            cacheKey = cache.generateCacheKey(entry.getId(), persister, source.getFactory(), source.getTenantIdentifier());
            lock = cache.lockItem((SharedSessionContractImplementor)source, cacheKey, entry.getVersion());
        } else {
            cacheKey = null;
            lock = null;
        }
        try {
            return ((ReactiveEntityPersister)persister).reactiveLock(entry.getId(), entry.getVersion(), object, lockOptions, (SharedSessionContractImplementor)source).thenAccept(v -> entry.setLockMode(lockOptions.getLockMode())).whenComplete((r, e) -> {
                if (canWriteToCache) {
                    persister.getCacheAccessStrategy().unlockItem((SharedSessionContractImplementor)source, cacheKey, lock);
                }
            });
        }
        catch (HibernateException he) {
            if (canWriteToCache) {
                persister.getCacheAccessStrategy().unlockItem((SharedSessionContractImplementor)source, cacheKey, lock);
            }
            throw he;
        }
    }

    public void onLock(LockEvent event) throws HibernateException {
        throw new UnsupportedOperationException();
    }
}

