/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.generator.values.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.internal.NaturalIdHelper;
import org.hibernate.generator.values.GeneratedValueBasicResultBuilder;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.generator.values.internal.GeneratedValuesImpl;
import org.hibernate.generator.values.internal.GeneratedValuesMappingProducer;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.id.insert.UniqueKeySelectingDelegate;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.id.insert.ReactiveInsertReturningDelegate;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.exec.spi.ReactiveValuesResultSet;
import org.hibernate.reactive.sql.results.internal.ReactiveDirectResultSetAccess;
import org.hibernate.reactive.sql.results.internal.ReactiveResultsHelper;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.sql.results.spi.ReactiveRowReader;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.type.descriptor.WrapperOptions;

@Internal
public class ReactiveGeneratedValuesHelper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(IdentifierGeneratorHelper.class);

    public static GeneratedValuesMutationDelegate getGeneratedValuesDelegate(EntityPersister persister, EventType timing) {
        boolean hasGeneratedProperties = !persister.getGeneratedProperties(timing).isEmpty();
        boolean hasRowId = timing == EventType.INSERT && persister.getRowIdMapping() != null;
        Dialect dialect = persister.getFactory().getJdbcServices().getDialect();
        if (hasRowId && dialect.supportsInsertReturning() && dialect.supportsInsertReturningRowId() && GeneratedValuesHelper.noCustomSql((EntityPersister)persister, (EventType)timing)) {
            return new ReactiveInsertReturningDelegate(persister, timing);
        }
        if (!hasGeneratedProperties) {
            return null;
        }
        if (dialect.supportsInsertReturningGeneratedKeys() && persister.getFactory().getSessionFactoryOptions().isGetGeneratedKeysEnabled()) {
            return new GetGeneratedKeysDelegate(persister, false, timing);
        }
        if (ReactiveGeneratedValuesHelper.supportsReturning(dialect, timing) && GeneratedValuesHelper.noCustomSql((EntityPersister)persister, (EventType)timing)) {
            return new ReactiveInsertReturningDelegate(persister, timing);
        }
        if (timing == EventType.INSERT && persister.getNaturalIdentifierProperties() != null && !persister.getEntityMetamodel().isNaturalIdentifierInsertGenerated()) {
            return new UniqueKeySelectingDelegate(persister, NaturalIdHelper.getNaturalIdPropertyNames((EntityPersister)persister), timing);
        }
        return null;
    }

    private static boolean supportsReturning(Dialect dialect, EventType timing) {
        return timing == EventType.INSERT ? dialect.supportsInsertReturning() : dialect.supportsUpdateReturning();
    }

    public static CompletionStage<GeneratedValues> getGeneratedValues(ResultSet resultSet, EntityPersister persister, EventType timing, WrapperOptions wrapperOptions) {
        if (resultSet == null) {
            return null;
        }
        GeneratedValuesMutationDelegate delegate = persister.getMutationDelegate(timing == EventType.INSERT ? MutationType.INSERT : MutationType.UPDATE);
        GeneratedValuesMappingProducer mappingProducer = (GeneratedValuesMappingProducer)delegate.getGeneratedValuesMappingProducer();
        List resultBuilders = mappingProducer.getResultBuilders();
        ArrayList<BasicValuedModelPart> generatedProperties = new ArrayList<BasicValuedModelPart>(resultBuilders.size());
        for (GeneratedValueBasicResultBuilder resultBuilder : resultBuilders) {
            generatedProperties.add(resultBuilder.getModelPart());
        }
        GeneratedValuesImpl generatedValues = new GeneratedValuesImpl(generatedProperties);
        return ReactiveGeneratedValuesHelper.readGeneratedValues(resultSet, persister, (JdbcValuesMappingProducer)mappingProducer, wrapperOptions.getSession()).thenApply(results -> {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Extracted generated values %s: %s", (Object)MessageHelper.infoString((EntityPersister)persister), results);
            }
            for (int i = 0; i < ((Object[])results).length; ++i) {
                generatedValues.addGeneratedValue((ModelPart)generatedProperties.get(i), results[i]);
            }
            return generatedValues;
        });
    }

    private static CompletionStage<Object[]> readGeneratedValues(ResultSet resultSet, EntityPersister persister, JdbcValuesMappingProducer mappingProducer, SharedSessionContractImplementor session) {
        ReactiveDirectResultSetAccess directResultSetAccess;
        BaseExecutionContext executionContext = new BaseExecutionContext(session);
        try {
            directResultSetAccess = new ReactiveDirectResultSetAccess(session, (PreparedStatement)resultSet.getStatement(), resultSet);
        }
        catch (SQLException e) {
            throw new HibernateException("Could not retrieve statement from generated values result set", (Throwable)e);
        }
        ReactiveValuesResultSet jdbcValues = new ReactiveValuesResultSet(directResultSetAccess, null, null, QueryOptions.NONE, true, mappingProducer.resolve((JdbcValuesMetadata)directResultSetAccess, session.getLoadQueryInfluencers(), session.getSessionFactory()), null, (ExecutionContext)executionContext);
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            public Object getEffectiveOptionalObject() {
                return null;
            }

            public String getEffectiveOptionalEntityName() {
                return null;
            }

            public Object getEffectiveOptionalId() {
                return null;
            }

            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl((ExecutionContext)executionContext, processingOptions);
        ReactiveRowReader<Object[]> rowReader = ReactiveResultsHelper.createRowReader(session.getSessionFactory(), RowTransformerArrayImpl.instance(), Object[].class, jdbcValues);
        ReactiveRowProcessingState rowProcessingState = new ReactiveRowProcessingState(valuesProcessingState, (ExecutionContext)executionContext, rowReader, jdbcValues);
        return ReactiveListResultsConsumer.instance(ReactiveListResultsConsumer.UniqueSemantic.NONE).consume(jdbcValues, session, processingOptions, valuesProcessingState, rowProcessingState, rowReader).thenApply(results -> {
            if (results.isEmpty()) {
                throw new HibernateException("The database returned no natively generated values : " + persister.getNavigableRole().getFullPath());
            }
            return (Object[])results.get(0);
        });
    }
}

