/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;

public class ReactiveGeneratorWrapper
implements IdentifierGenerator,
ExportableProducer,
ReactiveIdentifierGenerator<Object> {
    private final ReactiveIdentifierGenerator<?> reactiveGenerator;
    private final IdentifierGenerator generator;

    public ReactiveGeneratorWrapper(ReactiveIdentifierGenerator<?> reactiveGenerator) {
        this(reactiveGenerator, null);
    }

    public ReactiveGeneratorWrapper(ReactiveIdentifierGenerator<?> reactiveGenerator, IdentifierGenerator generator) {
        this.reactiveGenerator = reactiveGenerator;
        this.generator = generator;
    }

    public void initialize(SqlStringGenerationContext context) {
        if (this.reactiveGenerator instanceof IdentifierGenerator) {
            ((IdentifierGenerator)this.reactiveGenerator).initialize(context);
        }
        if (this.generator != null) {
            this.generator.initialize(context);
        }
    }

    @Override
    public CompletionStage<Object> generate(ReactiveConnectionSupplier session, Object entity) {
        return this.reactiveGenerator.generate(session, entity).thenApply(Function.identity());
    }

    public Object generate(SharedSessionContractImplementor session, Object object) {
        Objects.requireNonNull(this.generator, "Only a reactive generator is available");
        return this.generator.generate(session, object);
    }

    public void registerExportables(Database database) {
        if (this.generator != null) {
            this.generator.registerExportables(database);
        }
        if (this.reactiveGenerator instanceof ExportableProducer) {
            ((ExportableProducer)this.reactiveGenerator).registerExportables(database);
        }
    }
}

