/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.insert;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.util.concurrent.CompletionStage;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.id.insert.ReactiveInsertGeneratedIdentifierDelegate;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.type.Type;

public interface ReactiveAbstractReturningDelegate
extends ReactiveInsertGeneratedIdentifierDelegate {
    public PreparedStatement prepareStatement(String var1, SharedSessionContractImplementor var2);

    public PostInsertIdentityPersister getPersister();

    @Override
    default public CompletionStage<GeneratedValues> reactivePerformInsertReturning(String sql, SharedSessionContractImplementor session, Binder binder) {
        String identifierColumnName = this.getPersister().getIdentifierColumnNames()[0];
        JdbcServices jdbcServices = session.getJdbcServices();
        String insertSql = ReactiveAbstractReturningDelegate.createInsert(sql, identifierColumnName, jdbcServices.getDialect());
        Object[] params = PreparedStatementAdaptor.bind(arg_0 -> ((Binder)binder).bindValues(arg_0));
        return this.reactiveExecuteAndExtractReturning(insertSql, params, session).thenApply(this::validateGeneratedIdentityId);
    }

    public CompletionStage<GeneratedValues> reactiveExecuteAndExtractReturning(String var1, Object[] var2, SharedSessionContractImplementor var3);

    @Override
    default public CompletionStage<GeneratedValues> reactivePerformMutation(PreparedStatementDetails statementDetails, JdbcValueBindings valueBindings, Object entity, SharedSessionContractImplementor session) {
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            valueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        String identifierColumnName = this.getPersister().getIdentifierColumnNames()[0];
        JdbcServices jdbcServices = session.getJdbcServices();
        String insertSql = ReactiveAbstractReturningDelegate.createInsert(statementDetails.getSqlString(), identifierColumnName, jdbcServices.getDialect());
        return this.reactiveExecuteAndExtractReturning(insertSql, params, session).whenComplete((generatedValues, throwable) -> {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            valueBindings.afterStatement(statementDetails.getMutatingTableDetails());
        });
    }

    default public GeneratedValues validateGeneratedIdentityId(GeneratedValues generatedId) {
        if (generatedId == null) {
            throw LoggerFactory.make(Log.class, MethodHandles.lookup()).noNativelyGeneratedValueReturned();
        }
        Type identifierType = this.getPersister().getIdentifierType();
        if ((identifierType.getReturnedClass().equals(Short.class) || identifierType.getReturnedClass().equals(Integer.class)) && this.getPersister().getFactory().getJdbcServices().getDialect() instanceof CockroachDialect) {
            throw LoggerFactory.make(Log.class, MethodHandles.lookup()).invalidIdentifierTypeForCockroachDB(identifierType.getReturnedClass(), this.getPersister().getEntityName());
        }
        return generatedId;
    }

    private static String createInsert(String insertSql, String identifierColumnName, Dialect dialect) {
        Object sql = insertSql;
        String sqlEnd = " returning " + identifierColumnName;
        Dialect realDialect = DialectDelegateWrapper.extractRealDialect((Dialect)dialect);
        if (realDialect instanceof MySQLDialect) {
            int index = ((String)sql).lastIndexOf(sqlEnd);
            return index > -1 ? ((String)sql).substring(0, index) : sql;
        }
        if (realDialect instanceof SQLServerDialect) {
            int index = ((String)sql).lastIndexOf(sqlEnd);
            if (index > -1) {
                sql = ((String)sql).substring(0, index);
            }
            if (((String)sql).endsWith("default values")) {
                index = ((String)sql).indexOf("default values");
                sql = ((String)sql).substring(0, index);
                sql = (String)sql + "output inserted." + identifierColumnName + " default values";
            } else {
                sql = ((String)sql).replace(") values (", ") output inserted." + identifierColumnName + " values (");
            }
            return sql;
        }
        if (realDialect instanceof DB2Dialect) {
            return ((String)sql).replace(" values ( ))", " (" + identifierColumnName + ") values (default))");
        }
        if (realDialect instanceof OracleDialect) {
            String valuesStr = " values ( )";
            int index = ((String)sql).lastIndexOf(sqlEnd);
            if (index > -1) {
                sql = ((String)sql).substring(0, index);
            }
            if (((String)sql).endsWith(" values ( )")) {
                index = ((String)sql).lastIndexOf(" values ( )");
                sql = ((String)sql).substring(0, index);
                sql = (String)sql + " values (default)";
            }
            return sql;
        }
        return sql;
    }
}

