/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.Locale;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.EntityBatchLoader;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.internal.ReactiveLoaderHelper;
import org.hibernate.reactive.loader.ast.internal.ReactiveSingleIdEntityLoaderSupport;
import org.hibernate.reactive.loader.ast.spi.ReactiveSingleIdEntityLoader;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.BasicType;

public class ReactiveEntityBatchLoaderArrayParam<T>
extends ReactiveSingleIdEntityLoaderSupport<T>
implements EntityBatchLoader<CompletionStage<T>>,
ReactiveSingleIdEntityLoader<T>,
SqlArrayMultiKeyLoader {
    private final int domainBatchSize;
    private BasicEntityIdentifierMapping identifierMapping;
    private JdbcMapping arrayJdbcMapping;
    private JdbcParameter jdbcParameter;
    private SelectStatement sqlAst;
    private JdbcOperationQuerySelect jdbcSelectOperation;

    public ReactiveEntityBatchLoaderArrayParam(int domainBatchSize, EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        super(entityDescriptor, sessionFactory);
        this.domainBatchSize = domainBatchSize;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching enabled for `%s` (entity) using ARRAY strategy : %s", (Object)entityDescriptor.getEntityName(), (Object)domainBatchSize);
        }
        this.identifierMapping = (BasicEntityIdentifierMapping)this.getLoadable().getIdentifierMapping();
        Class<?> arrayClass = Array.newInstance(this.identifierMapping.getJavaType().getJavaTypeClass(), 0).getClass();
        this.arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping((BasicType)sessionFactory.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(arrayClass), (JdbcMapping)this.identifierMapping.getJdbcMapping(), arrayClass, (SessionFactoryImplementor)sessionFactory);
        this.jdbcParameter = new JdbcParameterImpl(this.arrayJdbcMapping);
        this.sqlAst = LoaderSelectBuilder.createSelectBySingleArrayParameter((Loadable)this.getLoadable(), (ValuedModelPart)this.identifierMapping, (LoadQueryInfluencers)new LoadQueryInfluencers(sessionFactory), (LockOptions)LockOptions.NONE, (JdbcParameter)this.jdbcParameter, (SessionFactoryImplementor)sessionFactory);
        this.jdbcSelectOperation = (JdbcOperationQuerySelect)sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, this.sqlAst).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    public int getDomainBatchSize() {
        return this.domainBatchSize;
    }

    public CompletionStage<T> load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return this.load(pkValue, null, lockOptions, readOnly, session);
    }

    public final CompletionStage<T> load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching entity `%s#%s`", (Object)this.getLoadable().getEntityName(), pkValue);
        }
        Object[] ids = this.resolveIdsToInitialize(pkValue, session);
        return this.initializeEntities(ids, pkValue, entityInstance, lockOptions, readOnly, session).thenApply(v -> {
            EntityKey entityKey = session.generateEntityKey(pkValue, this.getLoadable().getEntityPersister());
            return session.getPersistenceContext().getEntity(entityKey);
        });
    }

    protected Object[] resolveIdsToInitialize(Object pkValue, SharedSessionContractImplementor session) {
        Object[] idsToLoad = (Object[])Array.newInstance(this.identifierMapping.getJavaType().getJavaTypeClass(), this.domainBatchSize);
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableEntityIds(this.domainBatchSize, (index, value) -> {
            idsToLoad[index] = value;
        }, pkValue, this.getLoadable());
        return idsToLoad;
    }

    private CompletionStage<Void> initializeEntities(Object[] idsToInitialize, Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        return ReactiveLoaderHelper.loadByArrayParameter(idsToInitialize, this.sqlAst, this.jdbcSelectOperation, this.jdbcParameter, this.arrayJdbcMapping, pkValue, entityInstance, lockOptions, readOnly, session).thenAccept(objects -> {
            for (int i = 0; i < idsToInitialize.length; ++i) {
                Object id = idsToInitialize[i];
                if (id == null) continue;
                BatchFetchQueueHelper.removeBatchLoadableEntityKey((Object)id, (EntityMappingType)this.getLoadable(), (SharedSessionContractImplementor)session);
            }
        });
    }

    public String toString() {
        return String.format(Locale.ROOT, "EntityBatchLoaderArrayParam(%s [%s])", this.getLoadable().getEntityName(), this.domainBatchSize);
    }
}

