/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.sql.results.LoadingLogger;

public class ReactiveCacheEntityLoaderHelper {
    public static final ReactiveCacheEntityLoaderHelper INSTANCE = new ReactiveCacheEntityLoaderHelper();
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ReactiveCacheEntityLoaderHelper.class);

    private ReactiveCacheEntityLoaderHelper() {
    }

    public CacheEntityLoaderHelper.PersistenceContextEntry loadFromSessionCache(LoadEvent event, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        EventSource session = event.getSession();
        Object old = session.getEntityUsingInterceptor(keyToLoad);
        if (old != null) {
            EntityPersister persister;
            EntityEntry oldEntry = session.getPersistenceContext().getEntry(old);
            if (options.isCheckDeleted() && oldEntry.getStatus().isDeletedOrGone()) {
                LoadingLogger.LOGGER.debug((Object)"Load request found matching entity in context, but it is scheduled for removal; returning null");
                return new CacheEntityLoaderHelper.PersistenceContextEntry(old, CacheEntityLoaderHelper.EntityStatus.REMOVED_ENTITY_MARKER);
            }
            if (options.isAllowNulls() && !(persister = event.getSession().getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(keyToLoad.getEntityName())).isInstance(old)) {
                LOG.debug((Object)"Load request found matching entity in context, but the matched entity was of an inconsistent return type; returning null");
                return new CacheEntityLoaderHelper.PersistenceContextEntry(old, CacheEntityLoaderHelper.EntityStatus.INCONSISTENT_RTN_CLASS_MARKER);
            }
            ReactiveCacheEntityLoaderHelper.upgradeLock(old, oldEntry, event.getLockOptions(), event.getSession());
        }
        return new CacheEntityLoaderHelper.PersistenceContextEntry(old, CacheEntityLoaderHelper.EntityStatus.MANAGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource source) {
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        if (entry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getPersister().getEntityName());
        }
        EntityPersister persister = entry.getPersister();
        boolean cachingEnabled = persister.canWriteToCache();
        SoftLock lock = null;
        Object ck = null;
        try {
            if (cachingEnabled) {
                EntityDataAccess cache = persister.getCacheAccessStrategy();
                ck = cache.generateCacheKey(entry.getId(), persister, source.getFactory(), source.getTenantIdentifier());
                lock = cache.lockItem((SharedSessionContractImplementor)source, ck, entry.getVersion());
            }
            if (persister.isVersioned() && requestedLockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
                Object nextVersion = persister.forceVersionIncrement(entry.getId(), entry.getVersion(), (SharedSessionContractImplementor)source);
                entry.forceLocked(object, nextVersion);
            } else {
                ((ReactiveEntityPersister)persister).reactiveLock(entry.getId(), entry.getVersion(), object, lockOptions, (SharedSessionContractImplementor)source);
            }
            entry.setLockMode(requestedLockMode);
            if (!cachingEnabled) return;
        }
        catch (Throwable throwable) {
            if (!cachingEnabled) throw throwable;
            persister.getCacheAccessStrategy().unlockItem((SharedSessionContractImplementor)source, ck, lock);
            throw throwable;
        }
        persister.getCacheAccessStrategy().unlockItem((SharedSessionContractImplementor)source, ck, lock);
    }
}

