/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionLoaderNamedQuery;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionLoaderSingleKey;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;

public interface ReactiveAbstractCollectionPersister
extends ReactiveCollectionPersister {
    default public ReactiveConnection getReactiveConnection(SharedSessionContractImplementor session) {
        return ((ReactiveConnectionSupplier)session).getReactiveConnection();
    }

    default public CollectionLoader createNamedQueryCollectionLoader(CollectionPersister persister, NamedQueryMemento namedQueryMemento) {
        return new ReactiveCollectionLoaderNamedQuery(persister, namedQueryMemento);
    }

    default public CollectionLoader createSingleKeyCollectionLoader(LoadQueryInfluencers loadQueryInfluencers) {
        return new ReactiveCollectionLoaderSingleKey(this.getAttributeMapping(), loadQueryInfluencers, this.getFactory());
    }

    @Override
    public CompletionStage<Void> reactiveRecreate(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    @Override
    public CompletionStage<Void> reactiveRemove(Object var1, SharedSessionContractImplementor var2);

    @Override
    public CompletionStage<Void> reactiveDeleteRows(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    @Override
    public CompletionStage<Void> reactiveInsertRows(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    @Override
    public CompletionStage<Void> reactiveUpdateRows(PersistentCollection<?> var1, Object var2, SharedSessionContractImplementor var3);

    public boolean isRowDeleteEnabled();

    public boolean isRowInsertEnabled();
}

