/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.collection.mutation;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinator;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.mutation.ReactiveInsertRowsCoordinator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

public class ReactiveInsertRowsCoordinatorStandard
implements ReactiveInsertRowsCoordinator {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final CollectionMutationTarget mutationTarget;
    private final RowMutationOperations rowMutationOperations;
    private final BasicBatchKey batchKey;
    private MutationOperationGroup operationGroup;

    public ReactiveInsertRowsCoordinatorStandard(CollectionMutationTarget mutationTarget, RowMutationOperations rowMutationOperations) {
        this.mutationTarget = mutationTarget;
        this.rowMutationOperations = rowMutationOperations;
        this.batchKey = new BasicBatchKey(mutationTarget.getRolePath() + "#INSERT");
    }

    public CollectionMutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    public void insertRows(PersistentCollection<?> collection, Object id, InsertRowsCoordinator.EntryFilter entryChecker, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("reactiveInsertRows");
    }

    @Override
    public CompletionStage<Void> reactiveInsertRows(PersistentCollection<?> collection, Object id, InsertRowsCoordinator.EntryFilter entryChecker, SharedSessionContractImplementor session) {
        if (this.operationGroup == null) {
            this.operationGroup = this.createOperationGroup();
        }
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Inserting collection rows - %s : %s", (Object)this.mutationTarget.getRolePath(), id);
        }
        PluralAttributeMapping pluralAttribute = this.mutationTarget.getTargetPart();
        CollectionPersister collectionDescriptor = pluralAttribute.getCollectionDescriptor();
        Iterator entries = collection.entries(collectionDescriptor);
        collection.preInsert(collectionDescriptor);
        if (!entries.hasNext()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("No collection rows to insert - %s : %s", (Object)this.mutationTarget.getRolePath(), id);
            return CompletionStages.voidFuture();
        }
        ReactiveMutationExecutor mutationExecutor = this.reactiveMutationExecutor(session, this.operationGroup);
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        int[] counter = new int[]{0};
        RowMutationOperations.Values insertRowValues = this.rowMutationOperations.getInsertRowValues();
        return CompletionStages.loop(entries, (entry, integer) -> {
            int entryCount = counter[0];
            if (entryChecker == null || entryChecker.include(entry, entryCount, collection, pluralAttribute)) {
                insertRowValues.applyValues(collection, id, entry, entryCount, session, jdbcValueBindings);
                return mutationExecutor.executeReactive(entry, null, null, null, session).thenAccept(o -> {
                    counter[0] = counter[0] + 1;
                });
            }
            counter[0] = counter[0] + 1;
            return CompletionStages.voidFuture();
        }).thenAccept(unused -> ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Done inserting `%s` collection rows : %s", counter[0], (Object)this.mutationTarget.getRolePath())).whenComplete((unused, throwable) -> mutationExecutor.release());
    }

    private BasicBatchKey getBatchKey() {
        return this.batchKey;
    }

    private MutationOperationGroup createOperationGroup() {
        assert (this.mutationTarget.getTargetPart() != null);
        assert (this.mutationTarget.getTargetPart().getKeyDescriptor() != null);
        JdbcMutationOperation operation = this.rowMutationOperations.getInsertRowOperation();
        return MutationOperationGroupFactory.singleOperation((MutationType)MutationType.INSERT, (MutationTarget)this.mutationTarget, (MutationOperation)operation);
    }

    private ReactiveMutationExecutor reactiveMutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(this::getBatchKey, operationGroup, session);
    }
}

