/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import io.vertx.sqlclient.DatabaseException;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.adaptor.impl.ResultSetAdaptor;
import org.hibernate.reactive.pool.impl.SqlClientPool;
import org.hibernate.reactive.util.impl.CompletionStages;

public final class ExternalSqlClientPool
extends SqlClientPool {
    private final Pool pool;
    private final SqlStatementLogger sqlStatementLogger;
    private SqlExceptionHelper sqlExceptionHelper;

    public ExternalSqlClientPool(Pool pool, SqlStatementLogger sqlStatementLogger, SqlExceptionHelper sqlExceptionHelper) {
        this.pool = pool;
        this.sqlStatementLogger = sqlStatementLogger;
        this.sqlExceptionHelper = sqlExceptionHelper;
    }

    @Override
    protected Pool getPool() {
        return this.pool;
    }

    @Override
    protected SqlStatementLogger getSqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    @Override
    public SqlExceptionHelper getSqlExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public CompletionStage<Void> getCloseFuture() {
        return CompletionStages.voidFuture();
    }

    @Override
    public CompletionStage<ResultSet> selectJdbcOutsideTransaction(String sql, Object[] paramValues) {
        return this.preparedQueryOutsideTransaction(sql, Tuple.wrap((Object[])paramValues)).thenApply(ResultSetAdaptor::new);
    }

    public CompletionStage<RowSet<Row>> preparedQueryOutsideTransaction(String sql, Tuple parameters) {
        this.feedback(sql);
        return this.getPool().preparedQuery(sql).execute(parameters).toCompletionStage().handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable));
    }

    private <T> T convertException(T rows, String sql, Throwable sqlException) {
        if (sqlException == null) {
            return rows;
        }
        if (sqlException instanceof DatabaseException) {
            DatabaseException de = (DatabaseException)sqlException;
            sqlException = this.sqlExceptionHelper.convert(new SQLException(de.getMessage(), de.getSqlState(), de.getErrorCode()), "error executing SQL statement", sql);
        }
        return (T)CompletionStages.rethrow(sqlException);
    }

    private void feedback(String sql) {
        Objects.requireNonNull(sql, "SQL query cannot be null");
        FormatStyle formatStyle = this.sqlStatementLogger.isFormat() && !sql.contains(System.lineSeparator()) ? FormatStyle.BASIC : FormatStyle.NONE;
        this.sqlStatementLogger.logStatement(sql, formatStyle.getFormatter());
    }
}

