/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.impl;

import jakarta.persistence.EntityManagerFactory;
import java.util.Map;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.internal.SessionFactoryBuilderImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsBuilder;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.reactive.provider.ReactiveServiceRegistryBuilder;
import org.hibernate.reactive.provider.service.ReactiveSessionFactoryBuilder;

public final class ReactiveEntityManagerFactoryBuilder
extends EntityManagerFactoryBuilderImpl {
    public ReactiveEntityManagerFactoryBuilder(PersistenceUnitDescriptor persistenceUnitDescriptor, Map integration) {
        super(persistenceUnitDescriptor, integration);
    }

    protected StandardServiceRegistryBuilder getStandardServiceRegistryBuilder(BootstrapServiceRegistry bsr) {
        return ReactiveServiceRegistryBuilder.forJpa(bsr);
    }

    public EntityManagerFactory build() {
        MetadataImplementor metadata = this.metadata();
        SessionFactoryOptionsBuilder optionsBuilder = new SessionFactoryOptionsBuilder(metadata.getMetadataBuildingOptions().getServiceRegistry(), ((MetadataImpl)metadata).getBootstrapContext());
        optionsBuilder.enableCollectionInDefaultFetchGroup(true);
        int batchSize = ConfigurationHelper.getInt((String)"hibernate.jdbc.batch_size", (Map)this.getConfigurationValues(), (int)0);
        optionsBuilder.applyJdbcBatchSize(batchSize);
        SessionFactoryBuilderImpl defaultBuilder = new SessionFactoryBuilderImpl(metadata, optionsBuilder, metadata.getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext());
        ReactiveSessionFactoryBuilder reactiveSessionFactoryBuilder = new ReactiveSessionFactoryBuilder(metadata, (SessionFactoryBuilderImplementor)defaultBuilder);
        this.populateSfBuilder((SessionFactoryBuilder)reactiveSessionFactoryBuilder, this.getStandardServiceRegistry());
        try {
            return reactiveSessionFactoryBuilder.build();
        }
        catch (Exception e) {
            throw this.persistenceException("Unable to build Hibernate SessionFactory", e);
        }
    }
}

