/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.OptimizableGenerator;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.BindableType;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.Order;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.criteria.internal.NamedCriteriaQueryMementoImpl;
import org.hibernate.query.hql.internal.NamedHqlQueryMementoImpl;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.HqlInterpretation;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.internal.QuerySqmImpl;
import org.hibernate.query.sqm.internal.SqmInterpretationsKey;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.query.spi.ReactiveAbstractSelectionQuery;
import org.hibernate.reactive.query.sql.spi.ReactiveNonSelectQueryPlan;
import org.hibernate.reactive.query.sqm.internal.AggregatedSelectReactiveQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ConcreteSqmSelectReactiveQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ReactiveAggregatedNonSelectQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ReactiveMultiTableDeleteQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ReactiveMultiTableInsertQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ReactiveMultiTableUpdateQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ReactiveSimpleDeleteQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ReactiveSimpleInsertQueryPlan;
import org.hibernate.reactive.query.sqm.internal.ReactiveSimpleUpdateQueryPlan;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveSqmMultiTableInsertStrategy;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveSqmMultiTableMutationStrategy;
import org.hibernate.reactive.query.sqm.spi.ReactiveSelectQueryPlan;
import org.hibernate.reactive.session.ReactiveSqmQueryImplementor;
import org.hibernate.transform.ResultTransformer;

public class ReactiveQuerySqmImpl<R>
extends QuerySqmImpl<R>
implements ReactiveSqmQueryImplementor<R> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveAbstractSelectionQuery<R> selectionQueryDelegate;

    public ReactiveQuerySqmImpl(NamedHqlQueryMementoImpl memento, Class<R> expectedResultType, SharedSessionContractImplementor session) {
        super(memento, expectedResultType, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    public ReactiveQuerySqmImpl(NamedCriteriaQueryMementoImpl memento, Class<R> resultType, SharedSessionContractImplementor session) {
        super(memento, resultType, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    public ReactiveQuerySqmImpl(String hql, HqlInterpretation hqlInterpretation, Class<R> resultType, SharedSessionContractImplementor session) {
        super(hql, hqlInterpretation, resultType, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    public ReactiveQuerySqmImpl(SqmStatement<R> criteria, Class<R> resultType, SharedSessionContractImplementor session) {
        super(criteria, resultType, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    private ReactiveAbstractSelectionQuery<R> createSelectionQueryDelegate(SharedSessionContractImplementor session) {
        return new ReactiveAbstractSelectionQuery<Object>((SqmInterpretationsKey.InterpretationsKeySource)this, session, this::doReactiveList, () -> ((ReactiveQuerySqmImpl)this).getSqmStatement(), () -> ((ReactiveQuerySqmImpl)this).getTupleMetadata(), () -> ((ReactiveQuerySqmImpl)this).getDomainParameterXref(), () -> ((ReactiveQuerySqmImpl)this).getResultType(), () -> ((ReactiveQuerySqmImpl)this).getQueryString(), () -> ((ReactiveQuerySqmImpl)this).beforeQuery(), arg_0 -> ((ReactiveQuerySqmImpl)this).afterQuery(arg_0), AbstractSelectionQuery::uniqueElement);
    }

    @Override
    public CompletionStage<R> reactiveUnique() {
        return this.selectionQueryDelegate.reactiveUnique();
    }

    @Override
    public CompletionStage<R> getReactiveSingleResult() {
        return this.selectionQueryDelegate.getReactiveSingleResult();
    }

    public long getResultCount() {
        throw LOG.nonReactiveMethodCall("getReactiveResultCount()");
    }

    @Override
    public CompletionStage<Long> getReactiveResultCount() {
        return this.selectionQueryDelegate.getReactiveResultsCount(((SqmSelectStatement)this.getSqmStatement()).createCountQuery(), (DomainQueryExecutionContext)this);
    }

    @Override
    public CompletionStage<R> getReactiveSingleResultOrNull() {
        return this.selectionQueryDelegate.getReactiveSingleResultOrNull();
    }

    @Override
    public CompletionStage<Optional<R>> reactiveUniqueResultOptional() {
        return this.selectionQueryDelegate.reactiveUniqueResultOptional();
    }

    @Override
    public CompletionStage<List<R>> reactiveList() {
        return this.selectionQueryDelegate.reactiveList();
    }

    public R getSingleResult() {
        return this.selectionQueryDelegate.getSingleResult();
    }

    public R getSingleResultOrNull() {
        return this.selectionQueryDelegate.getSingleResultOrNull();
    }

    public R uniqueResult() {
        return this.selectionQueryDelegate.uniqueResult();
    }

    public Optional<R> uniqueResultOptional() {
        return this.selectionQueryDelegate.uniqueResultOptional();
    }

    public List<R> getResultList() {
        return this.selectionQueryDelegate.getResultList();
    }

    public Stream<R> getResultStream() {
        return this.selectionQueryDelegate.getResultStream();
    }

    private CompletionStage<List<R>> doReactiveList() {
        this.verifySelect();
        this.getSession().prepareForQueryExecution(this.requiresTxn(this.getQueryOptions().getLockOptions().findGreatestLockMode()));
        SqmSelectStatement sqmStatement = (SqmSelectStatement)this.getSqmStatement();
        boolean containsCollectionFetches = sqmStatement.containsCollectionFetches();
        boolean hasLimit = ReactiveQuerySqmImpl.hasLimit((SqmSelectStatement)sqmStatement, (MutableQueryOptions)this.getQueryOptions());
        boolean needsDistinct = containsCollectionFetches && (sqmStatement.usesDistinct() || ReactiveQuerySqmImpl.hasAppliedGraph((MutableQueryOptions)this.getQueryOptions()) || hasLimit);
        DomainQueryExecutionContext executionContextToUse = this.executionContextForDoList(containsCollectionFetches, hasLimit, needsDistinct);
        return this.resolveSelectReactiveQueryPlan().reactivePerformList(executionContextToUse).thenApply(list -> needsDistinct ? this.applyDistinct((SqmSelectStatement<?>)sqmStatement, hasLimit, (List<R>)list) : list);
    }

    private List<R> applyDistinct(SqmSelectStatement<?> sqmStatement, boolean hasLimit, List<R> list) {
        int max;
        int first = !hasLimit || this.getQueryOptions().getLimit().getFirstRow() == null ? this.getIntegerLiteral(sqmStatement.getOffset(), 0) : this.getQueryOptions().getLimit().getFirstRow().intValue();
        int n = max = !hasLimit || this.getQueryOptions().getLimit().getMaxRows() == null ? this.getMaxRows(sqmStatement, list.size()) : this.getQueryOptions().getLimit().getMaxRows().intValue();
        if (first > 0 || max != -1) {
            int resultSize = list.size();
            int toIndex = max != -1 ? first + max : resultSize;
            return list.subList(first, Math.min(toIndex, resultSize));
        }
        return list;
    }

    private ReactiveSelectQueryPlan<R> resolveSelectReactiveQueryPlan() {
        SqmInterpretationsKey cacheKey = SqmInterpretationsKey.createInterpretationsKey((SqmInterpretationsKey.InterpretationsKeySource)this);
        if (cacheKey != null) {
            return (ReactiveSelectQueryPlan)this.getSession().getFactory().getQueryEngine().getInterpretationCache().resolveSelectQueryPlan((QueryInterpretationCache.Key)cacheKey, () -> this.buildSelectQueryPlan());
        }
        return this.buildSelectQueryPlan();
    }

    protected ReactiveSelectQueryPlan<R> buildSelectQueryPlan() {
        SqmSelectStatement[] concreteSqmStatements = QuerySplitter.split((SqmSelectStatement)((SqmSelectStatement)this.getSqmStatement()));
        return concreteSqmStatements.length > 1 ? this.buildAggregatedSelectQueryPlan(concreteSqmStatements) : this.buildConcreteSelectQueryPlan(concreteSqmStatements[0], this.getResultType(), (QueryOptions)this.getQueryOptions());
    }

    private ReactiveSelectQueryPlan<R> buildAggregatedSelectQueryPlan(SqmSelectStatement<?>[] concreteSqmStatements) {
        ReactiveSelectQueryPlan[] aggregatedQueryPlans = new ReactiveSelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteSelectQueryPlan(concreteSqmStatements[i], this.getResultType(), (QueryOptions)this.getQueryOptions());
        }
        return new AggregatedSelectReactiveQueryPlan(aggregatedQueryPlans);
    }

    private <T> ReactiveSelectQueryPlan<T> buildConcreteSelectQueryPlan(SqmSelectStatement<?> concreteSqmStatement, Class<T> resultType, QueryOptions queryOptions) {
        return new ConcreteSqmSelectReactiveQueryPlan<T>(concreteSqmStatement, this.getQueryString(), this.getDomainParameterXref(), resultType, this.getTupleMetadata(), queryOptions);
    }

    public int executeUpdate() {
        throw LOG.nonReactiveMethodCall("executeReactiveUpdate");
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate() {
        this.verifyUpdate();
        this.getSession().checkTransactionNeededForUpdateOperation("Executing an update/delete query");
        this.beforeQuery();
        return this.doExecuteReactiveUpdate().handle((count, error) -> {
            this.handleException((Throwable)error);
            return count;
        }).whenComplete((rs, throwable) -> this.afterQuery(throwable == null));
    }

    public CompletionStage<Integer> doExecuteReactiveUpdate() {
        this.getSession().prepareForQueryExecution(true);
        return this.resolveNonSelectQueryPlan().executeReactiveUpdate((DomainQueryExecutionContext)this);
    }

    private void handleException(Throwable e) {
        if (e != null) {
            if (e instanceof IllegalQueryOperationException) {
                throw new IllegalStateException(e);
            }
            if (e instanceof TypeMismatchException) {
                throw new IllegalStateException(e);
            }
            if (e instanceof HibernateException) {
                throw this.getSession().getExceptionConverter().convert((HibernateException)e, this.getLockOptions());
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new HibernateException(e);
        }
    }

    private ReactiveNonSelectQueryPlan resolveNonSelectQueryPlan() {
        ReactiveNonSelectQueryPlan queryPlan = null;
        QueryInterpretationCache.Key cacheKey = SqmInterpretationsKey.generateNonSelectKey((SqmInterpretationsKey.InterpretationsKeySource)this);
        if (cacheKey != null) {
            queryPlan = (ReactiveNonSelectQueryPlan)this.getSession().getFactory().getQueryEngine().getInterpretationCache().getNonSelectQueryPlan(cacheKey);
        }
        if (queryPlan == null) {
            queryPlan = this.buildNonSelectQueryPlan();
            if (cacheKey != null) {
                this.getSession().getFactory().getQueryEngine().getInterpretationCache().cacheNonSelectQueryPlan(cacheKey, (NonSelectQueryPlan)queryPlan);
            }
        }
        return queryPlan;
    }

    private ReactiveNonSelectQueryPlan buildNonSelectQueryPlan() {
        if (this.getSqmStatement() instanceof SqmDeleteStatement) {
            return this.buildDeleteQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmUpdateStatement) {
            return this.buildUpdateQueryPlan();
        }
        if (this.getSqmStatement() instanceof SqmInsertStatement) {
            return this.buildInsertQueryPlan();
        }
        throw new UnsupportedOperationException("Query#executeUpdate for Statements of type [" + this.getSqmStatement() + "not yet supported");
    }

    private ReactiveNonSelectQueryPlan buildDeleteQueryPlan() {
        SqmDeleteStatement[] concreteSqmStatements = QuerySplitter.split((SqmDeleteStatement)((SqmDeleteStatement)this.getSqmStatement()));
        return concreteSqmStatements.length > 1 ? this.buildAggregatedDeleteQueryPlan(concreteSqmStatements) : this.buildConcreteDeleteQueryPlan(concreteSqmStatements[0]);
    }

    private ReactiveNonSelectQueryPlan buildConcreteDeleteQueryPlan(SqmDeleteStatement sqmDelete) {
        EntityDomainType entityDomainType = sqmDelete.getTarget().getModel();
        String entityNameToDelete = entityDomainType.getHibernateEntityName();
        EntityPersister entityDescriptor = this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityNameToDelete);
        ReactiveSqmMultiTableMutationStrategy multiTableStrategy = (ReactiveSqmMultiTableMutationStrategy)entityDescriptor.getSqmMultiTableMutationStrategy();
        return multiTableStrategy == null ? new ReactiveSimpleDeleteQueryPlan((EntityMappingType)entityDescriptor, sqmDelete, this.getDomainParameterXref()) : new ReactiveMultiTableDeleteQueryPlan(sqmDelete, this.getDomainParameterXref(), multiTableStrategy);
    }

    private ReactiveNonSelectQueryPlan buildAggregatedDeleteQueryPlan(SqmDeleteStatement[] concreteSqmStatements) {
        ReactiveNonSelectQueryPlan[] aggregatedQueryPlans = new ReactiveNonSelectQueryPlan[concreteSqmStatements.length];
        int x = concreteSqmStatements.length;
        for (int i = 0; i < x; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteDeleteQueryPlan(concreteSqmStatements[i]);
        }
        return new ReactiveAggregatedNonSelectQueryPlan(aggregatedQueryPlans);
    }

    private ReactiveNonSelectQueryPlan buildUpdateQueryPlan() {
        SqmUpdateStatement sqmUpdate = (SqmUpdateStatement)this.getSqmStatement();
        String entityNameToUpdate = sqmUpdate.getTarget().getModel().getHibernateEntityName();
        EntityPersister entityDescriptor = this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityNameToUpdate);
        ReactiveSqmMultiTableMutationStrategy multiTableStrategy = (ReactiveSqmMultiTableMutationStrategy)entityDescriptor.getSqmMultiTableMutationStrategy();
        return multiTableStrategy == null ? new ReactiveSimpleUpdateQueryPlan(sqmUpdate, this.getDomainParameterXref()) : new ReactiveMultiTableUpdateQueryPlan(sqmUpdate, this.getDomainParameterXref(), multiTableStrategy);
    }

    private ReactiveNonSelectQueryPlan buildInsertQueryPlan() {
        Optimizer optimizer;
        IdentifierGenerator identifierGenerator;
        SqmInsertStatement sqmInsert = (SqmInsertStatement)this.getSqmStatement();
        String entityNameToInsert = sqmInsert.getTarget().getModel().getHibernateEntityName();
        AbstractEntityPersister entityDescriptor = (AbstractEntityPersister)this.getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityNameToInsert);
        boolean useMultiTableInsert = entityDescriptor.isMultiTable();
        if (!useMultiTableInsert && !this.isSimpleValuesInsert(sqmInsert, (EntityPersister)entityDescriptor) && (identifierGenerator = entityDescriptor.getIdentifierGenerator()) instanceof BulkInsertionCapableIdentifierGenerator && identifierGenerator instanceof OptimizableGenerator && (optimizer = ((OptimizableGenerator)identifierGenerator).getOptimizer()) != null && optimizer.getIncrementSize() > 1) {
            boolean bl = useMultiTableInsert = !this.hasIdentifierAssigned(sqmInsert, (EntityPersister)entityDescriptor);
        }
        if (!useMultiTableInsert) {
            return new ReactiveSimpleInsertQueryPlan(sqmInsert, this.getDomainParameterXref());
        }
        return new ReactiveMultiTableInsertQueryPlan(sqmInsert, this.getDomainParameterXref(), (ReactiveSqmMultiTableInsertStrategy)entityDescriptor.getSqmMultiTableInsertStrategy());
    }

    @Override
    public ReactiveQuerySqmImpl<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> addQueryHint(String hint) {
        super.addQueryHint(hint);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setLockOptions(LockOptions lockOptions) {
        super.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setOrder(List<Order<? super R>> orders) {
        super.setOrder(orders);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setOrder(Order<? super R> order) {
        super.setOrder(order);
        return this;
    }

    @Override
    public <T> ReactiveQuerySqmImpl<T> setTupleTransformer(TupleTransformer<T> transformer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReactiveQuerySqmImpl<R> setResultListTransformer(ResultListTransformer transformer) {
        super.setResultListTransformer(transformer);
        return this;
    }

    @Deprecated
    public <T> ReactiveQuerySqmImpl<T> setResultTransformer(ResultTransformer<T> transformer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReactiveQuerySqmImpl<R> setMaxResults(int maxResult) {
        super.setMaxResults(maxResult);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setFirstResult(int startPosition) {
        this.applyFirstResult(startPosition);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setFlushMode(FlushModeType flushMode) {
        super.setFlushMode(flushMode);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setLockMode(LockModeType lockMode) {
        super.setLockMode(lockMode);
        return this;
    }

    @Override
    @Deprecated
    public ReactiveQuerySqmImpl<R> setAliasSpecificLockMode(String alias, LockMode lockMode) {
        super.setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    public ReactiveQuerySqmImpl<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        super.applyGraph(graph, semantic);
        return this;
    }

    public ReactiveQuerySqmImpl<R> applyLoadGraph(RootGraph graph) {
        super.applyLoadGraph(graph);
        return this;
    }

    public ReactiveQuerySqmImpl<R> applyFetchGraph(RootGraph graph) {
        super.applyFetchGraph(graph);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        super.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        super.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setHibernateLockMode(LockMode lockMode) {
        super.setHibernateLockMode(lockMode);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setProperties(Map bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameter(String name, P value, Class<P> javaType) {
        super.setParameter(name, value, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameter(String name, P value, BindableType<P> type) {
        super.setParameter(name, value, type);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameter(int position, P value, Class<P> javaType) {
        super.setParameter(position, value, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameter(int position, P value, BindableType<P> type) {
        super.setParameter(position, value, type);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        super.setParameter(parameter, value, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        super.setParameter(parameter, value, type);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(String name, P[] values, Class<P> javaType) {
        super.setParameterList(name, (Object[])values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, (Object[])values, type);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, (Object[])values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, (Object[])values, type);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(parameter, values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(parameter, values, type);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList(parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList(parameter, (Object[])values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveQuerySqmImpl<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList(parameter, (Object[])values, type);
        return this;
    }

    @Override
    public ReactiveQuerySqmImpl<R> setFollowOnLocking(boolean enable) {
        super.setFollowOnLocking(enable);
        return this;
    }

    @Override
    public void applyGraph(RootGraphImplementor<?> graph, GraphSemantic semantic) {
        super.applyGraph(graph, semantic);
    }

    @Override
    public ReactiveQuerySqmImpl<R> enableFetchProfile(String profileName) {
        this.selectionQueryDelegate.enableFetchProfile(profileName);
        return this;
    }
}

