/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.temptable;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.TableKeyExpressionCollector;
import org.hibernate.query.sqm.mutation.internal.temptable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.temptable.ColumnReferenceCheckingSqlAstWalker;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithoutIdTableHelper;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.query.sqm.mutation.internal.ReactiveSqmMutationStrategyHelper;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveExecuteWithTemporaryTableHelper;
import org.hibernate.reactive.query.sqm.mutation.internal.temptable.ReactiveTableBasedDeleteHandler;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveJdbcMutationExecutor;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.MutatingTableReferenceGroupWrapper;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryDelete;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class ReactiveRestrictedDeleteExecutionDelegate
implements ReactiveTableBasedDeleteHandler.ReactiveExecutionDelegate {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final EntityMappingType entityDescriptor;
    private final TemporaryTable idTable;
    private final AfterUseAction afterUseAction;
    private final SqmDeleteStatement<?> sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private final SessionFactoryImplementor sessionFactory;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final MultiTableSqmMutationConverter converter;

    public ReactiveRestrictedDeleteExecutionDelegate(EntityMappingType entityDescriptor, TemporaryTable idTable, AfterUseAction afterUseAction, SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, Function<SharedSessionContractImplementor, String> sessionUidAccess, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, QueryParameterBindings queryParameterBindings, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.idTable = idTable;
        this.afterUseAction = afterUseAction;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
        this.sessionUidAccess = sessionUidAccess;
        this.sessionFactory = sessionFactory;
        this.converter = new MultiTableSqmMutationConverter(entityDescriptor, sqmDelete, sqmDelete.getTarget(), domainParameterXref, queryOptions, loadQueryInfluencers, queryParameterBindings, (SqlAstCreationContext)sessionFactory);
    }

    @Override
    public CompletionStage<Integer> reactiveExecute(DomainQueryExecutionContext executionContext) {
        EntityPersister entityDescriptor = this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(this.sqmDelete.getTarget().getEntityName());
        String hierarchyRootTableName = ((Joinable)entityDescriptor).getTableName();
        TableGroup deletingTableGroup = this.converter.getMutatingTableGroup();
        TableReference hierarchyRootTableReference = deletingTableGroup.resolveTableReference(deletingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        Predicate specifiedRestriction = this.converter.visitWhereClause(this.sqmDelete.getWhereClause());
        PredicateCollector predicateCollector = new PredicateCollector(specifiedRestriction);
        entityDescriptor.applyBaseRestrictions((Consumer)predicateCollector, deletingTableGroup, true, executionContext.getSession().getLoadQueryInfluencers().getEnabledFilters(), null, (SqlAstCreationState)this.converter);
        this.converter.pruneTableGroupJoins();
        ColumnReferenceCheckingSqlAstWalker walker = new ColumnReferenceCheckingSqlAstWalker(hierarchyRootTableReference.getIdentificationVariable());
        if (predicateCollector.getPredicate() != null) {
            predicateCollector.getPredicate().accept((SqlAstWalker)walker);
        }
        boolean needsIdTable = !walker.isAllColumnReferencesFromIdentificationVariable() || entityDescriptor != entityDescriptor.getRootEntityDescriptor();
        SqmJdbcExecutionContextAdapter executionContextAdapter = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging((DomainQueryExecutionContext)executionContext);
        if (needsIdTable) {
            return this.executeWithIdTable(predicateCollector.getPredicate(), deletingTableGroup, this.converter.getJdbcParamsBySqmParam(), this.converter.getSqmParameterMappingModelExpressibleResolutions(), (ExecutionContext)executionContextAdapter);
        }
        return this.executeWithoutIdTable(predicateCollector.getPredicate(), deletingTableGroup, this.converter.getJdbcParamsBySqmParam(), this.converter.getSqmParameterMappingModelExpressibleResolutions(), this.converter.getSqlExpressionResolver(), (ExecutionContext)executionContextAdapter);
    }

    private CompletionStage<Integer> executeWithoutIdTable(Predicate suppliedPredicate, TableGroup tableGroup, Map<SqmParameter<?>, List<List<JdbcParameter>>> restrictionSqmParameterResolutions, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, SqlExpressionResolver sqlExpressionResolver, ExecutionContext executionContext) {
        assert (this.entityDescriptor == this.entityDescriptor.getRootEntityDescriptor());
        EntityPersister rootEntityPersister = this.entityDescriptor.getEntityPersister();
        String rootTableName = ((Joinable)rootEntityPersister).getTableName();
        NamedTableReference rootTableReference = (NamedTableReference)tableGroup.resolveTableReference(tableGroup.getNavigablePath(), rootTableName);
        QuerySpec matchingIdSubQuerySpec = ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec((NavigablePath)tableGroup.getNavigablePath(), (TableReference)rootTableReference, (Predicate)suppliedPredicate, (EntityPersister)rootEntityPersister, (SqlExpressionResolver)sqlExpressionResolver, (SessionFactoryImplementor)this.sessionFactory);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)this.domainParameterXref, (Map)SqmUtil.generateJdbcParamsXref((DomainParameterXref)this.domainParameterXref, () -> restrictionSqmParameterResolutions), (MappingMetamodel)this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> tableGroup, (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, (SharedSessionContractImplementor)executionContext.getSession());
        CompletionStage<Void> cleanUpCollectionTablesStage = ReactiveSqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
            if (suppliedPredicate == null) {
                return null;
            }
            ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
            QuerySpec idSelectFkSubQuery = fkDescriptor.getTargetPart().isEntityIdentifierMapping() ? matchingIdSubQuerySpec : ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec((NavigablePath)tableGroup.getNavigablePath(), (TableReference)rootTableReference, (Predicate)suppliedPredicate, (EntityPersister)rootEntityPersister, (SqlExpressionResolver)sqlExpressionResolver, (SessionFactoryImplementor)this.sessionFactory);
            return new InSubQueryPredicate(MappingModelCreationHelper.buildColumnReferenceExpression((TableGroup)new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), (ModelPart)fkDescriptor, null, (SessionFactoryImplementor)this.sessionFactory), (QueryPart)idSelectFkSubQuery, false);
        }, jdbcParameterBindings, executionContext);
        CompletionStage[] deleteFromNonRootStages = new CompletionStage[]{CompletionStages.voidFuture()};
        if (rootTableReference instanceof UnionTableReference) {
            MutableInteger rows = new MutableInteger();
            return cleanUpCollectionTablesStage.thenCompose(v -> this.visitUnionTableReferences(suppliedPredicate, tableGroup, sqlExpressionResolver, executionContext, matchingIdSubQuerySpec, jdbcParameterBindings, deleteFromNonRootStages, rows)).thenApply(o -> rows.get());
        }
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
            if (!tableExpression.equals(rootTableName)) {
                NamedTableReference tableReference = (NamedTableReference)tableGroup.getTableReference(tableGroup.getNavigablePath(), tableExpression, true);
                QuerySpec idMatchingSubQuerySpec = suppliedPredicate == null ? null : matchingIdSubQuerySpec;
                CompletableFuture future = new CompletableFuture();
                deleteFromNonRootStages[0] = deleteFromNonRootStages[0].thenCompose(v -> future);
                try {
                    this.deleteFromNonRootTableWithoutIdTable(tableReference, tableKeyColumnVisitationSupplier, sqlExpressionResolver, tableGroup, idMatchingSubQuerySpec, jdbcParameterBindings, executionContext).thenCompose(CompletionStages::voidFuture).whenComplete((unused, throwable) -> {
                        if (throwable == null) {
                            future.complete(unused);
                        } else {
                            future.completeExceptionally((Throwable)throwable);
                        }
                    });
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            }
        });
        return deleteFromNonRootStages[0].thenCompose(v -> this.deleteFromRootTableWithoutIdTable(rootTableReference, suppliedPredicate, jdbcParameterBindings, executionContext));
    }

    private CompletionStage<Void> visitUnionTableReferences(Predicate suppliedPredicate, TableGroup tableGroup, SqlExpressionResolver sqlExpressionResolver, ExecutionContext executionContext, QuerySpec matchingIdSubQuerySpec, JdbcParameterBindings jdbcParameterBindings, CompletionStage<Void>[] deleteFromNonRootStages, MutableInteger rows) {
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
            NamedTableReference tableReference = new NamedTableReference(tableExpression, tableGroup.getPrimaryTableReference().getIdentificationVariable());
            QuerySpec idMatchingSubQuerySpec = suppliedPredicate == null ? null : matchingIdSubQuerySpec;
            CompletableFuture future = new CompletableFuture();
            deleteFromNonRootStages[0] = deleteFromNonRootStages[0].thenCompose(v -> future);
            this.deleteFromNonRootTableWithoutIdTable(tableReference, tableKeyColumnVisitationSupplier, sqlExpressionResolver, tableGroup, idMatchingSubQuerySpec, jdbcParameterBindings, executionContext).thenAccept(arg_0 -> ((MutableInteger)rows).plus(arg_0)).whenComplete((unused, throwable) -> {
                if (throwable == null) {
                    future.complete(unused);
                } else {
                    future.completeExceptionally((Throwable)throwable);
                }
            });
        });
        return deleteFromNonRootStages[0];
    }

    private CompletionStage<Integer> deleteFromRootTableWithoutIdTable(NamedTableReference rootTableReference, Predicate predicate, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        return ReactiveRestrictedDeleteExecutionDelegate.executeSqlDelete(new DeleteStatement(rootTableReference, predicate), jdbcParameterBindings, executionContext);
    }

    private CompletionStage<Integer> deleteFromNonRootTableWithoutIdTable(NamedTableReference targetTableReference, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, SqlExpressionResolver sqlExpressionResolver, TableGroup rootTableGroup, QuerySpec matchingIdSubQuerySpec, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        InSubQueryPredicate tableDeletePredicate;
        assert (targetTableReference != null);
        LOG.tracef("deleteFromNonRootTable - %s", targetTableReference.getTableExpression());
        NamedTableReference deleteTableReference = new NamedTableReference(targetTableReference.getTableExpression(), "to_delete_", true);
        if (matchingIdSubQuerySpec == null) {
            tableDeletePredicate = null;
        } else {
            ArrayList deletingTableColumnRefs = new ArrayList();
            tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
                assert (deleteTableReference.getTableReference(selection.getContainingTableExpression()) != null);
                Expression expression = sqlExpressionResolver.resolveSqlExpression((TableReference)deleteTableReference, selection);
                deletingTableColumnRefs.add((ColumnReference)expression);
            });
            SqlTuple deletingTableColumnRefsExpression = deletingTableColumnRefs.size() == 1 ? (Expression)deletingTableColumnRefs.get(0) : new SqlTuple(deletingTableColumnRefs, (MappingModelExpressible)this.entityDescriptor.getIdentifierMapping());
            tableDeletePredicate = new InSubQueryPredicate((Expression)deletingTableColumnRefsExpression, (QueryPart)matchingIdSubQuerySpec, false);
        }
        DeleteStatement sqlAstDelete = new DeleteStatement(deleteTableReference, tableDeletePredicate);
        return ReactiveRestrictedDeleteExecutionDelegate.executeSqlDelete(sqlAstDelete, jdbcParameterBindings, executionContext).thenApply(rows -> {
            LOG.debugf("deleteFromNonRootTable - `%s` : %s rows", targetTableReference, rows);
            return rows;
        });
    }

    private static CompletionStage<Integer> executeSqlDelete(DeleteStatement sqlAst, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcOperationQueryDelete jdbcDelete = (JdbcOperationQueryDelete)jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildDeleteTranslator(factory, sqlAst).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return StandardReactiveJdbcMutationExecutor.INSTANCE.executeReactive((JdbcOperationQueryMutation)jdbcDelete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement(sql), (integer, preparedStatement) -> {}, executionContext);
    }

    private CompletionStage<Integer> executeWithIdTable(Predicate predicate, TableGroup deletingTableGroup, Map<SqmParameter<?>, List<List<JdbcParameter>>> restrictionSqmParameterResolutions, final Map<SqmParameter<?>, MappingModelExpressible<?>> paramTypeResolutions, ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings((QueryParameterBindings)executionContext.getQueryParameterBindings(), (DomainParameterXref)this.domainParameterXref, (Map)SqmUtil.generateJdbcParamsXref((DomainParameterXref)this.domainParameterXref, () -> restrictionSqmParameterResolutions), (MappingMetamodel)this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel(), navigablePath -> deletingTableGroup, (SqmParameterMappingModelResolutionAccess)new SqmParameterMappingModelResolutionAccess(){

            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return (MappingModelExpressible)paramTypeResolutions.get(parameter);
            }
        }, (SharedSessionContractImplementor)executionContext.getSession());
        return ReactiveExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.idTable, executionContext).thenCompose(v -> this.executeUsingIdTable(predicate, executionContext, jdbcParameterBindings).handle(CompletionStages::handle).thenCompose(resultHandler -> ReactiveExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.idTable, this.sessionUidAccess, this.afterUseAction, executionContext).thenCompose(resultHandler::getResultAsCompletionStage)));
    }

    private CompletionStage<Integer> executeUsingIdTable(Predicate predicate, ExecutionContext executionContext, JdbcParameterBindings jdbcParameterBindings) {
        return ReactiveExecuteWithTemporaryTableHelper.saveMatchingIdsIntoIdTable(this.converter, predicate, this.idTable, this.sessionUidAccess, jdbcParameterBindings, executionContext).thenCompose(rows -> {
            QuerySpec idTableIdentifierSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec((TemporaryTable)this.idTable, this.sessionUidAccess, (EntityMappingType)this.entityDescriptor, (ExecutionContext)executionContext);
            return ReactiveSqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> {
                ForeignKeyDescriptor fkDescriptor = attributeMapping.getKeyDescriptor();
                QuerySpec idTableFkSubQuery = fkDescriptor.getTargetPart().isEntityIdentifierMapping() ? idTableIdentifierSubQuery : ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec((TemporaryTable)this.idTable, (ModelPart)fkDescriptor.getTargetPart(), this.sessionUidAccess, (EntityMappingType)this.entityDescriptor, (ExecutionContext)executionContext);
                return new InSubQueryPredicate(MappingModelCreationHelper.buildColumnReferenceExpression((TableGroup)new MutatingTableReferenceGroupWrapper(new NavigablePath(attributeMapping.getRootPathName()), (ModelPartContainer)attributeMapping, (NamedTableReference)tableReference), (ModelPart)fkDescriptor, null, (SessionFactoryImplementor)this.sessionFactory), (QueryPart)idTableFkSubQuery, false);
            }, JdbcParameterBindings.NO_BINDINGS, executionContext).thenCompose(unused -> this.visitConstraintOrderedTables(idTableIdentifierSubQuery, executionContext).thenApply(v -> rows));
        });
    }

    private CompletionStage<Void> visitConstraintOrderedTables(QuerySpec idTableIdentifierSubQuery, ExecutionContext executionContext) {
        CompletionStage[] resultStage = new CompletionStage[]{CompletionStages.completedFuture(-1)};
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
            resultStage[0] = resultStage[0].thenCompose(arg_0 -> this.lambda$visitConstraintOrderedTables$24(tableExpression, (Supplier)tableKeyColumnVisitationSupplier, idTableIdentifierSubQuery, executionContext, arg_0));
        });
        return resultStage[0].thenCompose(CompletionStages::voidFuture);
    }

    private CompletionStage<Integer> deleteFromTableUsingIdTable(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        LOG.tracef("deleteFromTableUsingIdTable - %s", tableExpression);
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.entityDescriptor);
        NamedTableReference targetTable = new NamedTableReference(tableExpression, "to_delete_", true);
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(tableExpression));
            assert (!selection.isFormula());
            assert (selection.getCustomReadExpression() == null);
            assert (selection.getCustomWriteExpression() == null);
            keyColumnCollector.apply(new ColumnReference((TableReference)targetTable, selection));
        });
        InSubQueryPredicate predicate = new InSubQueryPredicate(keyColumnCollector.buildKeyExpression(), (QueryPart)idTableSubQuery, false);
        return ReactiveRestrictedDeleteExecutionDelegate.executeSqlDelete(new DeleteStatement(targetTable, (Predicate)predicate), JdbcParameterBindings.NO_BINDINGS, executionContext);
    }

    private /* synthetic */ CompletionStage lambda$visitConstraintOrderedTables$24(String tableExpression, Supplier tableKeyColumnVisitationSupplier, QuerySpec idTableIdentifierSubQuery, ExecutionContext executionContext, Integer ignore) {
        return this.deleteFromTableUsingIdTable(tableExpression, tableKeyColumnVisitationSupplier, idTableIdentifierSubQuery, executionContext);
    }
}

