/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal.temptable;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableExporter;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveTemporaryTableHelper {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public static CompletionStage<Void> cleanTemporaryTableRows(TemporaryTable temporaryTable, TemporaryTableExporter exporter, Function<SharedSessionContractImplementor, String> sessionUidAccess, SharedSessionContractImplementor session) {
        String sql = Parameters.instance(temporaryTable.getDialect()).process(exporter.getSqlTruncateCommand(temporaryTable, sessionUidAccess, session));
        Object[] params = PreparedStatementAdaptor.bind(ps -> {
            if (temporaryTable.getSessionUidColumn() != null) {
                String sessionUid = (String)sessionUidAccess.apply(session);
                ps.setString(1, sessionUid);
            }
        });
        return ReactiveTemporaryTableHelper.reactiveConnection(session).update(sql, params).thenCompose(CompletionStages::voidFuture);
    }

    private static ReactiveConnection reactiveConnection(SharedSessionContractImplementor session) {
        return ((ReactiveConnectionSupplier)session).getReactiveConnection();
    }

    private static void logException(String action, String creationCommand, TemporaryTable temporaryTable, Throwable throwable) {
        if (throwable != null) {
            if (creationCommand != null) {
                LOG.debugf("unable to " + action + " temporary table [%s]; `%s` failed : %s", temporaryTable.getQualifiedTableName(), creationCommand, throwable.getMessage());
            } else {
                LOG.debugf("unable to " + action + " temporary table [%s] : %s", temporaryTable.getQualifiedTableName(), throwable.getMessage());
            }
        }
    }

    private static void logStatement(String sql, JdbcServices jdbcServices) {
        SqlStatementLogger statementLogger = jdbcServices.getSqlStatementLogger();
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
    }

    public static class TemporaryTableDropWork
    implements ReactiveWork {
        private final TemporaryTable temporaryTable;
        private final TemporaryTableExporter exporter;
        private final SessionFactoryImplementor sessionFactory;

        public TemporaryTableDropWork(TemporaryTable temporaryTable, SessionFactoryImplementor sessionFactory) {
            this(temporaryTable, sessionFactory.getJdbcServices().getDialect().getTemporaryTableExporter(), sessionFactory);
        }

        public TemporaryTableDropWork(TemporaryTable temporaryTable, TemporaryTableExporter exporter, SessionFactoryImplementor sessionFactory) {
            this.temporaryTable = temporaryTable;
            this.exporter = exporter;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public CompletionStage<Void> reactiveExecute(ReactiveConnection connection) {
            JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
            try {
                String dropCommand = this.exporter.getSqlDropCommand(this.temporaryTable);
                ReactiveTemporaryTableHelper.logStatement(dropCommand, jdbcServices);
                return connection.update(dropCommand).handle((integer, throwable) -> {
                    ReactiveTemporaryTableHelper.logException("drop", dropCommand, this.temporaryTable, throwable);
                    return null;
                });
            }
            catch (Exception e) {
                ReactiveTemporaryTableHelper.logException("drop", null, this.temporaryTable, e);
                return CompletionStages.voidFuture();
            }
        }
    }

    public static class TemporaryTableCreationWork
    implements ReactiveWork {
        private final TemporaryTable temporaryTable;
        private final TemporaryTableExporter exporter;
        private final SessionFactoryImplementor sessionFactory;

        public TemporaryTableCreationWork(TemporaryTable temporaryTable, SessionFactoryImplementor sessionFactory) {
            this(temporaryTable, sessionFactory.getJdbcServices().getDialect().getTemporaryTableExporter(), sessionFactory);
        }

        public TemporaryTableCreationWork(TemporaryTable temporaryTable, TemporaryTableExporter exporter, SessionFactoryImplementor sessionFactory) {
            this.temporaryTable = temporaryTable;
            this.exporter = exporter;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public CompletionStage<Void> reactiveExecute(ReactiveConnection connection) {
            JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
            try {
                String creationCommand = this.exporter.getSqlCreateCommand(this.temporaryTable);
                ReactiveTemporaryTableHelper.logStatement(creationCommand, jdbcServices);
                return connection.executeUnprepared(creationCommand).handle((integer, throwable) -> {
                    ReactiveTemporaryTableHelper.logException("create", creationCommand, this.temporaryTable, throwable);
                    return null;
                });
            }
            catch (Exception e) {
                ReactiveTemporaryTableHelper.logException("create", null, this.temporaryTable, e);
                return CompletionStages.voidFuture();
            }
        }
    }

    public static interface ReactiveWork {
        public CompletionStage<Void> reactiveExecute(ReactiveConnection var1);
    }
}

