/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph;

import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.hibernate.Incubating;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

@Incubating
public interface ReactiveInitializer<Data extends InitializerData> {
    public Data getData(RowProcessingState var1);

    public CompletionStage<Void> reactiveResolveInstance(Data var1);

    default public CompletionStage<Void> reactiveResolveKey(Data data) {
        data.setState(Initializer.State.KEY_RESOLVED);
        return this.forEachReactiveSubInitializer(ReactiveInitializer::reactiveResolveKey, (InitializerData)data);
    }

    default public CompletionStage<Void> reactiveResolveKey(RowProcessingState rowProcessingState) {
        Data data = this.getData(rowProcessingState);
        return this.reactiveResolveKey(data);
    }

    default public CompletionStage<Void> reactiveResolveInstance(Object instance, Data data) {
        return this.reactiveResolveKey(data);
    }

    default public CompletionStage<Void> reactiveResolveInstance(Object instance, RowProcessingState rowProcessingState) {
        return this.reactiveResolveInstance(instance, this.getData(rowProcessingState));
    }

    default public CompletionStage<Void> reactiveResolveInstance(ReactiveRowProcessingState rowProcessingState) {
        return this.reactiveResolveInstance(this.getData(rowProcessingState));
    }

    public CompletionStage<Void> reactiveInitializeInstance(Data var1);

    default public CompletionStage<Void> reactiveInitializeInstance(ReactiveRowProcessingState rowProcessingState) {
        return this.reactiveInitializeInstance(this.getData(rowProcessingState));
    }

    public CompletionStage<Void> forEachReactiveSubInitializer(BiFunction<ReactiveInitializer<?>, RowProcessingState, CompletionStage<Void>> var1, InitializerData var2);

    public Object getResolvedInstance(Data var1);
}

