/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.embeddable.internal;

import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntityFetchJoinedImpl;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.NonAggregatedIdentifierMappingInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ReactiveNonAggregatedIdentifierMappingInitializer
extends NonAggregatedIdentifierMappingInitializer
implements ReactiveInitializer<NonAggregatedIdentifierMappingInitializer.NonAggregatedIdentifierMappingInitializerData> {
    public ReactiveNonAggregatedIdentifierMappingInitializer(EmbeddableResultGraphNode resultDescriptor, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer) {
        super(resultDescriptor, parent, creationState, isResultInitializer, ReactiveNonAggregatedIdentifierMappingInitializer::convertFetch);
    }

    private static Fetch convertFetch(Fetch fetch) {
        if (fetch instanceof EntityFetchJoinedImpl) {
            return new ReactiveEntityFetchJoinedImpl((EntityFetchJoinedImpl)fetch);
        }
        return fetch;
    }

    @Override
    public CompletionStage<Void> reactiveResolveKey(NonAggregatedIdentifierMappingInitializer.NonAggregatedIdentifierMappingInitializerData data) {
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return CompletionStages.voidFuture();
        }
        data.setInstance(null);
        data.setState(Initializer.State.KEY_RESOLVED);
        if (this.getInitializers().length == 0) {
            return this.reactiveResolveInstance(data);
        }
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        boolean[] dataIsMissing = new boolean[]{false};
        return CompletionStages.loop(this.getInitializers(), initializer -> {
            if (dataIsMissing[0]) {
                return CompletionStages.voidFuture();
            }
            Object subData = ((ReactiveInitializer)initializer).getData(rowProcessingState);
            return ((ReactiveInitializer)initializer).reactiveResolveKey(subData).thenAccept(v -> {
                if (subData.getState() == Initializer.State.MISSING) {
                    data.setState(Initializer.State.MISSING);
                    dataIsMissing[0] = true;
                }
            });
        });
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(NonAggregatedIdentifierMappingInitializer.NonAggregatedIdentifierMappingInitializerData data) {
        super.resolveInstance(data);
        return CompletionStages.voidFuture();
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(NonAggregatedIdentifierMappingInitializer.NonAggregatedIdentifierMappingInitializerData data) {
        super.initializeInstance(data);
        return CompletionStages.voidFuture();
    }

    @Override
    public CompletionStage<Void> forEachReactiveSubInitializer(BiFunction<ReactiveInitializer<?>, RowProcessingState, CompletionStage<Void>> consumer, InitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        return CompletionStages.loop(this.getInitializers(), initializer -> (CompletionStage)consumer.apply((ReactiveInitializer)initializer, rowProcessingState));
    }

    @Override
    public Object getResolvedInstance(NonAggregatedIdentifierMappingInitializer.NonAggregatedIdentifierMappingInitializerData data) {
        return super.getResolvedInstance((InitializerData)data);
    }
}

