/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.results.graph.ReactiveDomainResultsAssembler;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.type.descriptor.java.JavaType;

public class ReactiveEntityAssembler
extends EntityAssembler
implements ReactiveDomainResultsAssembler {
    public <T> ReactiveEntityAssembler(JavaType<T> javaType, EntityInitializer initializer) {
        super(javaType, initializer);
    }

    public CompletionStage<Object> reactiveAssemble(ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        ReactiveInitializer reactiveInitializer = (ReactiveInitializer)this.getInitializer();
        Object data = reactiveInitializer.getData(rowProcessingState);
        Initializer.State state = data.getState();
        if (state == Initializer.State.KEY_RESOLVED) {
            return reactiveInitializer.reactiveResolveInstance(data).thenApply(v -> reactiveInitializer.getResolvedInstance(data));
        }
        return CompletionStages.completedFuture(reactiveInitializer.getResolvedInstance(data));
    }
}

