/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.hibernate.EntityFilterException;
import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ReactiveEntitySelectFetchInitializer<Data extends EntitySelectFetchInitializer.EntitySelectFetchInitializerData>
extends EntitySelectFetchInitializer<Data>
implements ReactiveInitializer<Data> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final boolean isEnhancedForLazyLoading;

    public ReactiveEntitySelectFetchInitializer(InitializerParent<?> parent, ToOneAttributeMapping fetchedAttribute, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResult<?> keyResult, boolean affectedByFilter, AssemblerCreationState creationState) {
        super(parent, fetchedAttribute, fetchedNavigable, concreteDescriptor, keyResult, affectedByFilter, creationState);
        this.isEnhancedForLazyLoading = concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new ReactiveEntitySelectFetchInitializerData(this, rowProcessingState);
    }

    public void resolveInstance(RowProcessingState rowProcessingState) {
        super.resolveInstance(rowProcessingState);
    }

    public void initializeInstance(EntitySelectFetchInitializer.EntitySelectFetchInitializerData data) {
        throw LOG.nonReactiveMethodCall("reactiveInitializeInstance");
    }

    protected void initialize(EntitySelectFetchInitializer.EntitySelectFetchInitializerData data) {
        throw LOG.nonReactiveMethodCall("reactiveInitialize");
    }

    @Override
    public CompletionStage<Void> forEachReactiveSubInitializer(BiFunction<ReactiveInitializer<?>, RowProcessingState, CompletionStage<Void>> consumer, InitializerData data) {
        Initializer initializer = this.getKeyAssembler().getInitializer();
        if (initializer != null) {
            return consumer.apply((ReactiveInitializer)initializer, data.getRowProcessingState());
        }
        return CompletionStages.voidFuture();
    }

    protected CompletionStage<Void> reactiveInitialize(EntitySelectFetchInitializer.EntitySelectFetchInitializerData ormData) {
        ReactiveEntitySelectFetchInitializerData data = (ReactiveEntitySelectFetchInitializerData)ormData;
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        EntityKey entityKey = new EntityKey(data.getEntityIdentifier(), this.concreteDescriptor);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
        if (holder != null) {
            data.setInstance(persistenceContext.proxyFor(holder, this.concreteDescriptor));
            if (holder.getEntityInitializer() == null) {
                if (data.getInstance() != null && Hibernate.isInitialized((Object)data.getInstance())) {
                    data.setState(Initializer.State.INITIALIZED);
                    return CompletionStages.voidFuture();
                }
            } else {
                if (holder.getEntityInitializer() != this) {
                    data.setState(Initializer.State.INITIALIZED);
                    return CompletionStages.voidFuture();
                }
                if (data.getInstance() == null) {
                    assert (holder.getProxy() == null) : "How to handle this case?";
                    data.setState(Initializer.State.INITIALIZED);
                    return CompletionStages.voidFuture();
                }
            }
        }
        data.setState(Initializer.State.INITIALIZED);
        String entityName = this.concreteDescriptor.getEntityName();
        return ((ReactiveSession)session).reactiveInternalLoad(entityName, data.getEntityIdentifier(), true, this.toOneMapping.isInternalLoadNullable()).thenAccept(instance -> {
            data.setInstance(instance);
            if (instance == null) {
                if (this.toOneMapping.getNotFoundAction() != NotFoundAction.IGNORE) {
                    if (this.affectedByFilter) {
                        throw new EntityFilterException(entityName, data.getEntityIdentifier(), this.toOneMapping.getNavigableRole().getFullPath());
                    }
                    if (this.toOneMapping.getNotFoundAction() == NotFoundAction.EXCEPTION) {
                        throw new FetchNotFoundException(entityName, data.getEntityIdentifier());
                    }
                }
                rowProcessingState.getSession().getPersistenceContextInternal().claimEntityHolderIfPossible(new EntityKey(data.getEntityIdentifier(), this.concreteDescriptor), null, rowProcessingState.getJdbcValuesSourceProcessingState(), (EntityInitializer)this);
            }
            boolean unwrapProxy = this.toOneMapping.isUnwrapProxy() && this.isEnhancedForLazyLoading;
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)data.getInstance());
            if (lazyInitializer != null) {
                lazyInitializer.setUnwrap(unwrapProxy);
            }
        });
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(Data original) {
        if (original.getState() != Initializer.State.KEY_RESOLVED) {
            return CompletionStages.voidFuture();
        }
        ReactiveEntitySelectFetchInitializerData data = (ReactiveEntitySelectFetchInitializerData)((Object)original);
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        data.setEntityIdentifier(this.keyAssembler.assemble(rowProcessingState));
        if (data.getEntityIdentifier() == null) {
            data.setState(Initializer.State.MISSING);
            data.setInstance(null);
            return CompletionStages.voidFuture();
        }
        data.setState(Initializer.State.INITIALIZED);
        return this.reactiveInitialize(data);
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(Data data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return CompletionStages.voidFuture();
        }
        data.setState(Initializer.State.INITIALIZED);
        Hibernate.initialize((Object)data.getInstance());
        return CompletionStages.voidFuture();
    }

    @Override
    public Object getResolvedInstance(Data data) {
        return super.getResolvedInstance(data);
    }

    public static class ReactiveEntitySelectFetchInitializerData
    extends EntitySelectFetchInitializer.EntitySelectFetchInitializerData {
        public ReactiveEntitySelectFetchInitializerData(EntitySelectFetchInitializer<?> initializer, RowProcessingState rowProcessingState) {
            super(initializer, rowProcessingState);
        }

        public Object getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public void setEntityIdentifier(Object entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }
    }
}

