/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.spi;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.sql.exec.spi.ReactiveRowProcessingState;
import org.hibernate.reactive.sql.exec.spi.ReactiveValuesResultSet;
import org.hibernate.reactive.sql.results.spi.ReactiveResultsConsumer;
import org.hibernate.reactive.sql.results.spi.ReactiveRowReader;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ReactiveListResultsConsumer<R>
implements ReactiveResultsConsumer<List<R>, R> {
    private static final ReactiveListResultsConsumer<?> NEVER_DE_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.NEVER);
    private static final ReactiveListResultsConsumer<?> ALLOW_DE_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.ALLOW);
    private static final ReactiveListResultsConsumer<?> IGNORE_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.NONE);
    private static final ReactiveListResultsConsumer<?> DE_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.FILTER);
    private static final ReactiveListResultsConsumer<?> ERROR_DUP_CONSUMER = new ReactiveListResultsConsumer(UniqueSemantic.ASSERT);
    private final UniqueSemantic uniqueSemantic;

    private static boolean validateUniqueResult(Boolean unique) {
        if (!unique.booleanValue()) {
            throw new HibernateException(String.format(Locale.ROOT, "Duplicate row was found and `%s` was specified", new Object[]{UniqueSemantic.ASSERT}));
        }
        return true;
    }

    @Override
    public CompletionStage<List<R>> consume(ReactiveValuesResultSet jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, ReactiveRowProcessingState rowProcessingState, ReactiveRowReader<R> rowReader) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        TypeConfiguration typeConfiguration = session.getTypeConfiguration();
        QueryOptions queryOptions = rowProcessingState.getQueryOptions();
        persistenceContext.beforeLoad();
        persistenceContext.getLoadContexts().register((JdbcValuesSourceProcessingState)jdbcValuesSourceProcessingState);
        JavaType<R> domainResultJavaType = this.resolveDomainResultJavaType(rowReader.getDomainResultResultJavaType(), rowReader.getResultJavaTypes(), typeConfiguration);
        boolean isEntityResultType = domainResultJavaType instanceof EntityJavaType;
        Results results = (this.uniqueSemantic == UniqueSemantic.ALLOW || this.uniqueSemantic == UniqueSemantic.FILTER) && isEntityResultType ? new EntityResult(domainResultJavaType) : new Results(domainResultJavaType);
        Supplier<CompletionStage<Boolean>> addToResultsSupplier = this.addToResultsSupplier(results, rowReader, rowProcessingState, processingOptions, isEntityResultType);
        int[] readRows = new int[]{0};
        return CompletionStages.whileLoop(() -> rowProcessingState.next().thenCompose(arg_0 -> ReactiveListResultsConsumer.lambda$consume$1((Supplier)addToResultsSupplier, rowProcessingState, readRows, arg_0))).thenApply(v -> this.finishUp(rowReader, rowProcessingState, jdbcValuesSourceProcessingState, results, readRows, queryOptions)).handle(CompletionStages::handle).thenCompose(handler -> {
            this.end(jdbcValues, session, jdbcValuesSourceProcessingState, persistenceContext, (Throwable)handler.getThrowable());
            return handler.getResultAsCompletionStage();
        });
    }

    private List<R> finishUp(ReactiveRowReader<R> rowReader, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, Results<R> results, int[] readRows, QueryOptions queryOptions) {
        rowReader.finishUp(rowProcessingState);
        jdbcValuesSourceProcessingState.finishUp(readRows[0] > 1);
        ResultListTransformer resultListTransformer = queryOptions.getResultListTransformer();
        return resultListTransformer != null ? resultListTransformer.transformList(results.getResults()) : results.getResults();
    }

    private Supplier<CompletionStage<Boolean>> addToResultsSupplier(Results<R> results, ReactiveRowReader<R> rowReader, ReactiveRowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions processingOptions, boolean isEntityResultType) {
        if (this.uniqueSemantic == UniqueSemantic.FILTER || this.uniqueSemantic == UniqueSemantic.ASSERT && rowReader.hasCollectionInitializers() || this.uniqueSemantic == UniqueSemantic.ALLOW && isEntityResultType) {
            return () -> rowReader.reactiveReadRow(rowProcessingState, processingOptions).thenApply(results::addUnique);
        }
        if (this.uniqueSemantic == UniqueSemantic.ASSERT) {
            return () -> rowReader.reactiveReadRow(rowProcessingState, processingOptions).thenApply(results::addUnique).thenApply(ReactiveListResultsConsumer::validateUniqueResult);
        }
        return () -> rowReader.reactiveReadRow(rowProcessingState, processingOptions).thenApply(results::add);
    }

    private void end(ReactiveValuesResultSet jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, PersistenceContext persistenceContext, Throwable ex) {
        try {
            jdbcValues.finishUp(session);
            persistenceContext.afterLoad();
            persistenceContext.getLoadContexts().deregister((JdbcValuesSourceProcessingState)jdbcValuesSourceProcessingState);
            persistenceContext.initializeNonLazyCollections();
        }
        catch (Throwable e) {
            if (ex != null) {
                ex.addSuppressed(e);
                throw (RuntimeException)ex;
            }
            throw e;
        }
        if (ex != null) {
            throw (RuntimeException)ex;
        }
    }

    public static <R> ReactiveListResultsConsumer<R> instance(UniqueSemantic uniqueSemantic) {
        switch (uniqueSemantic) {
            case ASSERT: {
                return ERROR_DUP_CONSUMER;
            }
            case FILTER: {
                return DE_DUP_CONSUMER;
            }
            case NEVER: {
                return NEVER_DE_DUP_CONSUMER;
            }
            case ALLOW: {
                return ALLOW_DE_DUP_CONSUMER;
            }
        }
        return IGNORE_DUP_CONSUMER;
    }

    public ReactiveListResultsConsumer(UniqueSemantic uniqueSemantic) {
        this.uniqueSemantic = uniqueSemantic;
    }

    private JavaType<R> resolveDomainResultJavaType(Class<R> domainResultResultJavaType, List<JavaType<?>> resultJavaTypes, TypeConfiguration typeConfiguration) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        if (domainResultResultJavaType != null) {
            return javaTypeRegistry.resolveDescriptor(domainResultResultJavaType);
        }
        if (resultJavaTypes.size() == 1) {
            return resultJavaTypes.get(0);
        }
        return javaTypeRegistry.resolveDescriptor(Object[].class);
    }

    @Override
    public boolean canResultsBeCached() {
        return true;
    }

    public String toString() {
        return ReactiveResultsConsumer.class.getSimpleName() + "(" + this.uniqueSemantic + ")";
    }

    private static /* synthetic */ CompletionStage lambda$consume$1(Supplier addToResultsSupplier, ReactiveRowProcessingState rowProcessingState, int[] readRows, Boolean hasNext) {
        if (hasNext.booleanValue()) {
            return ((CompletionStage)addToResultsSupplier.get()).thenApply(added -> {
                rowProcessingState.finishRowProcessing((boolean)added);
                readRows[0] = readRows[0] + 1;
                return true;
            });
        }
        return CompletionStages.falseFuture();
    }

    private static class EntityResult<R>
    extends Results<R> {
        private static final Object DUMP_VALUE = new Object();
        private final IdentityHashMap<R, Object> added = new IdentityHashMap();

        public EntityResult(JavaType resultJavaType) {
            super(resultJavaType);
        }

        @Override
        public boolean addUnique(R result) {
            if (this.added.put(result, DUMP_VALUE) == null) {
                super.add(result);
                return true;
            }
            return false;
        }
    }

    private static class Results<R> {
        private final List<R> results = new ArrayList<R>();
        private final JavaType resultJavaType;

        public Results(JavaType resultJavaType) {
            this.resultJavaType = resultJavaType;
        }

        public boolean addUnique(R result) {
            for (R r : this.results) {
                if (!this.resultJavaType.areEqual(r, result)) continue;
                return false;
            }
            this.results.add(result);
            return true;
        }

        public boolean add(R result) {
            this.results.add(result);
            return true;
        }

        public List<R> getResults() {
            return this.results;
        }
    }

    public static enum UniqueSemantic {
        NONE,
        FILTER,
        ASSERT,
        NEVER,
        ALLOW;

    }
}

