/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.stage.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.Cache;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.reactive.common.spi.Implementor;
import org.hibernate.reactive.context.Context;
import org.hibernate.reactive.context.impl.BaseKey;
import org.hibernate.reactive.context.impl.MultitenantKey;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.session.impl.ReactiveSessionImpl;
import org.hibernate.reactive.session.impl.ReactiveStatelessSessionImpl;
import org.hibernate.reactive.stage.Stage;
import org.hibernate.reactive.stage.impl.StageSessionImpl;
import org.hibernate.reactive.stage.impl.StageStatelessSessionImpl;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;

public class StageSessionFactoryImpl
implements Stage.SessionFactory,
Implementor {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final SessionFactoryImpl delegate;
    private final ReactiveConnectionPool connectionPool;
    private final Context context;
    private final BaseKey<Stage.Session> contextKeyForSession;
    private final BaseKey<Stage.StatelessSession> contextKeyForStatelessSession;

    public StageSessionFactoryImpl(SessionFactoryImpl delegate) {
        this.delegate = delegate;
        this.context = (Context)delegate.getServiceRegistry().getService(Context.class);
        this.connectionPool = (ReactiveConnectionPool)delegate.getServiceRegistry().getService(ReactiveConnectionPool.class);
        this.contextKeyForSession = new BaseKey<Stage.Session>(Stage.Session.class, delegate.getUuid());
        this.contextKeyForStatelessSession = new BaseKey<Stage.StatelessSession>(Stage.StatelessSession.class, delegate.getUuid());
    }

    @Override
    public String getUuid() {
        return this.delegate.getUuid();
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.delegate.getServiceRegistry();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public CompletionStage<Stage.Session> openSession() {
        SessionCreationOptions options = this.options();
        return this.connection(options.getTenantIdentifier()).thenCompose(connection -> this.create((ReactiveConnection)connection, () -> new ReactiveSessionImpl(this.delegate, options, (ReactiveConnection)connection))).thenApply(StageSessionImpl::new);
    }

    @Override
    public CompletionStage<Stage.Session> openSession(String tenantId) {
        return this.connection(tenantId).thenCompose(connection -> this.create((ReactiveConnection)connection, () -> new ReactiveSessionImpl(this.delegate, this.options(tenantId), (ReactiveConnection)connection))).thenApply(StageSessionImpl::new);
    }

    @Override
    public CompletionStage<Stage.StatelessSession> openStatelessSession() {
        SessionCreationOptions options = this.options();
        return this.connection(options.getTenantIdentifier()).thenCompose(connection -> this.create((ReactiveConnection)connection, () -> new ReactiveStatelessSessionImpl(this.delegate, options, (ReactiveConnection)connection))).thenApply(StageStatelessSessionImpl::new);
    }

    @Override
    public CompletionStage<Stage.StatelessSession> openStatelessSession(String tenantId) {
        return this.connection(tenantId).thenCompose(connection -> this.create((ReactiveConnection)connection, () -> new ReactiveStatelessSessionImpl(this.delegate, this.options(tenantId), (ReactiveConnection)connection))).thenApply(StageStatelessSessionImpl::new);
    }

    private <S> CompletionStage<S> create(ReactiveConnection connection, Supplier<S> supplier) {
        try {
            return CompletionStages.completedFuture(supplier.get());
        }
        catch (Throwable throwable) {
            return connection.close().handle(this::handler).handle((ignore, t) -> CompletionStages.rethrow(throwable));
        }
    }

    private SessionCreationOptions options() {
        return new SessionFactoryImpl.SessionBuilderImpl(this.delegate);
    }

    private SessionCreationOptions options(String tenantIdentifier) {
        return new SessionFactoryImpl.SessionBuilderImpl(this.delegate).tenantIdentifier(tenantIdentifier);
    }

    private CompletionStage<ReactiveConnection> connection(String tenantId) {
        return tenantId == null ? this.connectionPool.getConnection() : this.connectionPool.getConnection(tenantId);
    }

    @Override
    public <T> CompletionStage<T> withSession(Function<Stage.Session, CompletionStage<T>> work) {
        Objects.requireNonNull(work, "parameter 'work' is required");
        Stage.Session current = this.context.get(this.contextKeyForSession);
        if (current != null && current.isOpen()) {
            LOG.debug("Reusing existing open Stage.Session which was found in the current Vert.x context");
            return work.apply(current);
        }
        LOG.debug("No existing open Stage.Session was found in the current Vert.x context: opening a new instance");
        return this.executeInContext(v -> this.withSession(this.openSession(), work, this.contextKeyForSession));
    }

    @Override
    public <T> CompletionStage<T> withSession(String tenantId, Function<Stage.Session, CompletionStage<T>> work) {
        Objects.requireNonNull(tenantId, "parameter 'tenantId' is required");
        Objects.requireNonNull(work, "parameter 'work' is required");
        MultitenantKey<Stage.Session> key = new MultitenantKey<Stage.Session>(this.contextKeyForSession, tenantId);
        Stage.Session current = this.context.get(key);
        if (current != null && current.isOpen()) {
            LOG.debugf("Reusing existing open Stage.Session which was found in the current Vert.x context for current tenant '%s'", tenantId);
            return work.apply(current);
        }
        LOG.debugf("No existing open Stage.Session was found in the current Vert.x context for current tenant '%s': opening a new instance", tenantId);
        return this.executeInContext(v -> this.withSession(this.openSession(tenantId), work, key));
    }

    @Override
    public <T> CompletionStage<T> withStatelessSession(Function<Stage.StatelessSession, CompletionStage<T>> work) {
        Objects.requireNonNull(work, "parameter 'work' is required");
        Stage.StatelessSession current = this.context.get(this.contextKeyForStatelessSession);
        if (current != null && current.isOpen()) {
            LOG.debug("Reusing existing open Stage.StatelessSession which was found in the current Vert.x context");
            return work.apply(current);
        }
        LOG.debug("No existing open Stage.StatelessSession was found in the current Vert.x context: opening a new instance");
        return this.executeInContext(v -> this.withSession(this.openStatelessSession(), work, this.contextKeyForStatelessSession));
    }

    @Override
    public <T> CompletionStage<T> withStatelessSession(String tenantId, Function<Stage.StatelessSession, CompletionStage<T>> work) {
        Objects.requireNonNull(tenantId, "parameter 'tenantId' is required");
        Objects.requireNonNull(work, "parameter 'work' is required");
        MultitenantKey<Stage.StatelessSession> key = new MultitenantKey<Stage.StatelessSession>(this.contextKeyForStatelessSession, tenantId);
        Stage.StatelessSession current = this.context.get(key);
        if (current != null && current.isOpen()) {
            LOG.debugf("Reusing existing open Stage.StatelessSession which was found in the current Vert.x context for current tenant '%s'", tenantId);
            return work.apply(current);
        }
        LOG.debugf("No existing open Stage.StatelessSession was found in the current Vert.x context for current tenant '%s': opening a new instance", tenantId);
        return this.executeInContext(v -> this.withSession(this.openStatelessSession(tenantId), work, this.contextKeyForStatelessSession));
    }

    private <T> CompletionStage<T> executeInContext(Function<Void, CompletionStage<T>> fun) {
        return CompletionStages.voidFuture().thenComposeAsync(fun, this.context);
    }

    private <S extends Stage.Closeable, T> CompletionStage<T> withSession(CompletionStage<S> sessionStage, Function<S, CompletionStage<T>> work, Context.Key<S> contextKey) {
        return sessionStage.thenCompose(session -> {
            this.context.put(contextKey, session);
            return CompletionStages.voidFuture().thenCompose(v -> (CompletionStage)work.apply(session)).handle(this::handler).thenCompose(handler -> {
                this.context.remove(contextKey);
                return session.close().handle((unused, throwable) -> handler.apply(null));
            });
        });
    }

    private <T> Function<Void, T> handler(T result, Throwable exception) {
        return exception == null ? v -> result : v -> CompletionStages.rethrow(exception);
    }

    @Override
    public <T> CompletionStage<T> withTransaction(BiFunction<Stage.Session, Stage.Transaction, CompletionStage<T>> work) {
        return this.withSession(s -> s.withTransaction((Stage.Transaction t) -> (CompletionStage)work.apply((Stage.Session)s, (Stage.Transaction)t)));
    }

    @Override
    public <T> CompletionStage<T> withStatelessTransaction(BiFunction<Stage.StatelessSession, Stage.Transaction, CompletionStage<T>> work) {
        return this.withStatelessSession(s -> s.withTransaction((Stage.Transaction t) -> (CompletionStage)work.apply((Stage.StatelessSession)s, (Stage.Transaction)t)));
    }

    @Override
    public <T> CompletionStage<T> withTransaction(String tenantId, BiFunction<Stage.Session, Stage.Transaction, CompletionStage<T>> work) {
        return this.withSession(tenantId, s -> s.withTransaction((Stage.Transaction t) -> (CompletionStage)work.apply((Stage.Session)s, (Stage.Transaction)t)));
    }

    @Override
    public <T> CompletionStage<T> withStatelessTransaction(String tenantId, BiFunction<Stage.StatelessSession, Stage.Transaction, CompletionStage<T>> work) {
        return this.withStatelessSession(tenantId, s -> s.withTransaction((Stage.Transaction t) -> (CompletionStage)work.apply((Stage.StatelessSession)s, (Stage.Transaction)t)));
    }

    @Override
    public Metamodel getMetamodel() {
        return this.delegate.getMetamodel();
    }

    @Override
    public Cache getCache() {
        return this.delegate.getCache();
    }

    @Override
    public Statistics getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }
}

