/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.type.descriptor.jdbc;

import io.vertx.core.json.JsonObject;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;

public class ReactiveJsonJdbcType
extends JsonJdbcType {
    public static final ReactiveJsonJdbcType INSTANCE = new ReactiveJsonJdbcType(null);

    protected ReactiveJsonJdbcType(EmbeddableMappingType embeddableMappingType) {
        super(embeddableMappingType);
    }

    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new ReactiveJsonJdbcType(mappingType);
    }

    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, ReactiveJsonJdbcType.this.toJsonObject(value, javaType, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, (Object)ReactiveJsonJdbcType.this.toJsonObject(value, javaType, options));
            }
        };
    }

    protected <X> JsonObject toJsonObject(X value, JavaType<X> javaType, WrapperOptions options) {
        return new JsonObject(this.toString(value, javaType, options));
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, (JdbcType)this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return ReactiveJsonJdbcType.this.fromString(ReactiveJsonJdbcType.toJsonString(rs.getObject(paramIndex)), this.getJavaType(), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return ReactiveJsonJdbcType.this.fromString(ReactiveJsonJdbcType.toJsonString(statement.getObject(index)), this.getJavaType(), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return ReactiveJsonJdbcType.this.fromString(ReactiveJsonJdbcType.toJsonString(statement.getObject(name)), this.getJavaType(), options);
            }
        };
    }

    private static String toJsonString(Object value) {
        if (value == null) {
            return null;
        }
        return ((JsonObject)value).encode();
    }
}

