/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.util.async.impl;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.hibernate.reactive.util.async.impl.AsyncCloseable;
import org.hibernate.reactive.util.async.impl.AsyncIterators;
import org.hibernate.reactive.util.async.impl.AsyncTrampoline;
import org.hibernate.reactive.util.async.impl.Either;
import org.hibernate.reactive.util.impl.CompletionStages;

public interface AsyncIterator<T>
extends AsyncCloseable {
    public CompletionStage<Either<End, T>> nextStage();

    @Override
    default public CompletionStage<Void> close() {
        return CompletionStages.voidFuture();
    }

    default public <U> AsyncIterator<U> thenApply(Function<? super T, ? extends U> fn) {
        return AsyncIterators.thenApplyImpl(this, fn);
    }

    default public <U> AsyncIterator<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return AsyncIterators.thenComposeImpl(this, fn);
    }

    default public AsyncIterator<T> filter(Predicate<? super T> predicate) {
        final Predicate<Either> shouldKeepLooking = either -> either.fold(end -> false, predicate.negate()::test);
        return new AsyncIterator<T>(){

            @Override
            public CompletionStage<Either<End, T>> nextStage() {
                return AsyncIterator.this.nextStage().thenCompose(t -> AsyncTrampoline.asyncWhile(shouldKeepLooking, c -> AsyncIterator.this.nextStage(), t));
            }

            @Override
            public CompletionStage<Void> close() {
                return AsyncIterator.this.close();
            }
        };
    }

    default public <A, R> AsyncIterator<R> batch(final Collector<? super T, A, R> collector, final BiPredicate<? super A, ? super T> shouldAddToBatch) {
        return new AsyncIterator<R>(){
            private Either<End, T> lastAdvance = null;

            @Override
            public CompletionStage<Either<End, R>> nextStage() {
                return this.lastAdvance == null ? AsyncIterator.this.nextStage().thenCompose(eitherT -> {
                    this.lastAdvance = eitherT;
                    return this.collectBatch();
                }) : this.collectBatch();
            }

            @Override
            public CompletionStage<Void> close() {
                return AsyncIterator.this.close();
            }

            private CompletionStage<Either<End, R>> collectBatch() {
                return this.lastAdvance.fold(end -> End.endStage(), (? super R ignoredT) -> {
                    Object batch = collector.supplier().get();
                    return AsyncTrampoline.asyncWhile(eitherT -> eitherT.fold(end -> false, (? super R t) -> shouldAddToBatch.test(batch, t)), eitherT -> {
                        collector.accumulator().accept(batch, eitherT.fold(end -> {
                            throw new IllegalStateException();
                        }, (? super R t) -> t));
                        return AsyncIterator.this.nextStage();
                    }, this.lastAdvance).thenApply(eitherT -> {
                        this.lastAdvance = eitherT;
                        return Either.right(AsyncIterators.finishContainer(batch, collector));
                    });
                });
            }
        };
    }

    default public <A, R> AsyncIterator<R> batch(final Collector<? super T, A, R> collector, final int batchSize) {
        class CountingCollector
        implements Collector<T, 1CountingContainer, R>,
        Supplier<1CountingContainer>,
        BiConsumer<1CountingContainer, T>,
        BinaryOperator<1CountingContainer>,
        BiPredicate<1CountingContainer, T> {
            private final Supplier<A> parentSupplier;
            private final BiConsumer<A, ? super T> parentAccumulator;
            private final BinaryOperator<A> parentCombiner;
            private final Set<Collector.Characteristics> characteristics;

            CountingCollector() {
                this.parentSupplier = collector.supplier();
                this.parentAccumulator = collector.accumulator();
                this.parentCombiner = collector.combiner();
                EnumSet<Collector.Characteristics> characteristics = EnumSet.copyOf(collector.characteristics());
                characteristics.remove((Object)Collector.Characteristics.CONCURRENT);
                characteristics.remove((Object)Collector.Characteristics.IDENTITY_FINISH);
                this.characteristics = Collections.unmodifiableSet(characteristics);
            }

            @Override
            public Supplier<1CountingContainer> supplier() {
                return this;
            }

            @Override
            public BiConsumer<1CountingContainer, T> accumulator() {
                return this;
            }

            @Override
            public BinaryOperator<1CountingContainer> combiner() {
                return this;
            }

            @Override
            public Function<1CountingContainer, R> finisher() {
                return countingContainer -> {
                    class CountingContainer {
                        final A container;
                        int size;

                        public CountingContainer(A container, int size) {
                            this.container = container;
                            this.size = size;
                        }
                    }
                    return AsyncIterators.finishContainer(countingContainer.container, collector);
                };
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return this.characteristics;
            }

            @Override
            public 1CountingContainer get() {
                return new CountingContainer(this.parentSupplier.get(), 0);
            }

            @Override
            public void accept(1CountingContainer countingContainer, T t) {
                this.parentAccumulator.accept(countingContainer.container, t);
                ++countingContainer.size;
            }

            @Override
            public 1CountingContainer apply(1CountingContainer c1, 1CountingContainer c2) {
                Object combined = this.parentCombiner.apply(c1.container, c2.container);
                if (combined == c1.container) {
                    c1.size += c2.size;
                    return c1;
                }
                return new CountingContainer(combined, c1.size + c2.size);
            }

            @Override
            public boolean test(1CountingContainer countingContainer, T t) {
                return countingContainer.size < batchSize;
            }
        }
        CountingCollector counter = new CountingCollector();
        return this.batch(counter, counter);
    }

    default public <U> CompletionStage<U> fold(U identity, BiFunction<U, ? super T, U> accumulator) {
        Object[] uarr = new Object[]{identity};
        return this.collect(() -> uarr, (u, t) -> {
            uarr[0] = accumulator.apply(uarr[0], t);
        }).thenApply(arr -> arr[0]);
    }

    default public <R, A> CompletionStage<R> collect(Collector<? super T, A, R> collector) {
        Object container = collector.supplier().get();
        BiConsumer acc = collector.accumulator();
        return this.forEach(t -> acc.accept(container, (Object)t)).thenApply(ig -> AsyncIterators.finishContainer(container, collector));
    }

    default public <R> CompletionStage<R> collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        Object container = supplier.get();
        return this.forEach(t -> accumulator.accept(container, (Object)t)).thenApply(ig -> container);
    }

    public static AsyncIterator<Long> range(final long start, final long end) {
        if (start >= end) {
            return AsyncIterator.empty();
        }
        return new AsyncIterator<Long>(){
            long counter;
            {
                this.counter = start;
            }

            @Override
            public CompletionStage<Either<End, Long>> nextStage() {
                if (this.counter < end) {
                    return CompletionStages.completedFuture(Either.right(this.counter++));
                }
                return End.endStage();
            }
        };
    }

    default public CompletionStage<Void> forEach(Consumer<? super T> action) {
        return AsyncTrampoline.asyncWhile(() -> this.nextStage().thenApply(eitherT -> {
            eitherT.forEach(ig -> {}, action);
            return eitherT.isRight();
        }));
    }

    default public CompletionStage<Optional<T>> find(Predicate<? super T> predicate) {
        CompletionStage<Either> future = AsyncIterators.convertSynchronousException(this.filter(predicate)::nextStage);
        return future.thenApply(e -> e.right());
    }

    public static <T> AsyncIterator<T> empty() {
        return AsyncIterators.EMPTY_ITERATOR;
    }

    public static <T> AsyncIterator<T> fromIterator(Iterator<? extends T> iterator) {
        return () -> CompletionStages.completedFuture(iterator.hasNext() ? Either.right(iterator.next()) : End.end());
    }

    public static <T> AsyncIterator<T> generate(Supplier<? extends CompletionStage<T>> supplier) {
        return () -> ((CompletionStage)supplier.get()).thenApply(Either::right);
    }

    public static enum End {
        END;

        private static final Either<End, ?> ITERATION_END;
        private static final CompletionStage<? extends Either<End, ?>> END_FUTURE;

        public static <T> Either<End, T> end() {
            return ITERATION_END;
        }

        public static <T> CompletionStage<Either<End, T>> endStage() {
            return END_FUTURE;
        }

        public String toString() {
            return "End of iteration";
        }

        static {
            ITERATION_END = Either.left(END);
            END_FUTURE = CompletionStages.completedFuture(ITERATION_END);
        }
    }
}

