/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.List;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneDocumentElementBuilder;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneObjectFieldBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentContentImpl;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexObjectField;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;

class LuceneNestedObjectFieldBuilder
extends AbstractLuceneObjectFieldBuilder {
    LuceneNestedObjectFieldBuilder(LuceneIndexModel model, LuceneIndexObjectField schemaNode, AbstractLuceneDocumentElementBuilder parent) {
        super(model, schemaNode, parent, new LuceneDocumentContentImpl());
    }

    @Override
    void contribute(MultiTenancyStrategy multiTenancyStrategy, String tenantId, String routingKey, String rootId, List<Document> nestedDocuments) {
        Document document = this.documentContent.finalizeDocument(multiTenancyStrategy, tenantId, routingKey);
        document.add(MetadataFields.searchableMetadataField(MetadataFields.typeFieldName(), "child"));
        document.add(MetadataFields.searchableMetadataField(MetadataFields.idFieldName(), rootId));
        document.add(MetadataFields.searchableMetadataField(MetadataFields.nestedDocumentPathFieldName(), this.schemaNode.absolutePath()));
        super.contribute(multiTenancyStrategy, tenantId, routingKey, rootId, nestedDocuments);
        nestedDocuments.add(document);
    }
}

