/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.util.Objects;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.lowlevel.codec.impl.HibernateSearchKnnVectorsFormat;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneDocumentContent;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneVectorFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;

public abstract class AbstractLuceneVectorFieldCodec<F>
implements LuceneVectorFieldCodec<F> {
    protected final FieldType fieldType;
    protected final VectorSimilarityFunction vectorSimilarity;
    private final int dimension;
    private final Storage storage;
    private final Indexing indexing;
    private final F indexNullAsValue;
    private final HibernateSearchKnnVectorsFormat knnVectorsFormat;

    protected AbstractLuceneVectorFieldCodec(VectorSimilarityFunction vectorSimilarity, int dimension, Storage storage, Indexing indexing, F indexNullAsValue, HibernateSearchKnnVectorsFormat knnVectorsFormat) {
        this.vectorSimilarity = vectorSimilarity;
        this.dimension = dimension;
        this.storage = storage;
        this.indexing = indexing;
        this.indexNullAsValue = indexNullAsValue;
        this.knnVectorsFormat = knnVectorsFormat;
        this.fieldType = new FieldType();
        this.fieldType.setVectorAttributes(dimension, this.vectorEncoding(), vectorSimilarity);
        this.fieldType.freeze();
    }

    @Override
    public final void addToDocument(LuceneDocumentContent documentBuilder, String absoluteFieldPath, F value) {
        if (value == null && this.indexNullAsValue != null) {
            value = this.indexNullAsValue;
        }
        if (value == null) {
            return;
        }
        byte[] encodedValue = (byte[])this.encode(value);
        if (Indexing.ENABLED == this.indexing) {
            documentBuilder.addField(this.createIndexField(absoluteFieldPath, value));
        }
        if (Storage.ENABLED == this.storage) {
            documentBuilder.addField(this.toStoredField(absoluteFieldPath, encodedValue));
        }
    }

    private IndexableField toStoredField(String absoluteFieldPath, byte[] encodedValue) {
        return new StoredField(absoluteFieldPath, new BytesRef(encodedValue));
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractLuceneVectorFieldCodec other = (AbstractLuceneVectorFieldCodec)obj;
        return this.dimension == other.dimension && this.vectorSimilarity == other.vectorSimilarity && Objects.equals((Object)this.knnVectorsFormat, (Object)other.knnVectorsFormat);
    }

    protected abstract IndexableField createIndexField(String var1, F var2);

    protected abstract VectorEncoding vectorEncoding();

    @Override
    public KnnVectorsFormat knnVectorFormat() {
        return this.knnVectorsFormat;
    }

    @Override
    public int getConfiguredDimensions() {
        return this.dimension;
    }

    @Override
    public VectorSimilarityFunction getVectorSimilarity() {
        return this.vectorSimilarity;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{vectorSimilarity=" + this.vectorSimilarity + ", dimension=" + this.dimension + ", knnVectorsFormat=" + this.knnVectorsFormat + "}";
    }
}

