/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.highlighter.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.vectorhighlight.SimpleBoundaryScanner;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneFastVectorSearchHighlighter;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LucenePlainSearchHighlighter;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneUnifiedSearchHighlighter;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.engine.search.highlighter.SearchHighlighter;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterEncoder;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterFragmenter;
import org.hibernate.search.engine.search.highlighter.dsl.HighlighterTagSchema;
import org.hibernate.search.engine.search.highlighter.spi.BoundaryScannerType;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterBuilder;
import org.hibernate.search.engine.search.highlighter.spi.SearchHighlighterType;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class LuceneAbstractSearchHighlighter
implements SearchHighlighter {
    protected static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Encoder DEFAULT_ENCODER = new DefaultEncoder();
    private static final Encoder HTML_ENCODER = new SimpleHTMLEncoder();
    private static final List<String> DEFAULT_PRE_TAGS = Collections.singletonList("<em>");
    private static final List<String> DEFAULT_POST_TAGS = Collections.singletonList("</em>");
    private static final List<String> STYLED_SCHEMA_PRE_TAG = CollectionHelper.asImmutableList((Object[])new String[]{"<em class=\"hlt1\">", "<em class=\"hlt2\">", "<em class=\"hlt3\">", "<em class=\"hlt4\">", "<em class=\"hlt5\">", "<em class=\"hlt6\">", "<em class=\"hlt7\">", "<em class=\"hlt8\">", "<em class=\"hlt9\">", "<em class=\"hlt10\">"});
    private static final List<String> STYLED_SCHEMA_POST_TAGS = DEFAULT_POST_TAGS;
    protected final Set<String> indexNames;
    protected final Character[] boundaryChars;
    protected final Integer boundaryMaxScan;
    protected final Integer fragmentSize;
    protected final Integer noMatchSize;
    protected final Integer numberOfFragments;
    protected final Boolean orderByScore;
    protected final List<String> preTags;
    protected final List<String> postTags;
    protected final BoundaryScannerType boundaryScannerType;
    protected final Locale boundaryScannerLocale;
    protected final HighlighterFragmenter fragmenterType;
    protected final Integer phraseLimit;
    protected final Encoder encoder;

    protected LuceneAbstractSearchHighlighter(Builder builder) {
        this(builder.scope.hibernateSearchIndexNames(), builder.boundaryChars(), builder.boundaryMaxScan(), builder.fragmentSize(), builder.noMatchSize(), builder.numberOfFragments(), builder.orderByScore(), HighlighterTagSchema.STYLED.equals((Object)builder.tagSchema()) ? STYLED_SCHEMA_PRE_TAG : builder.preTags(), HighlighterTagSchema.STYLED.equals((Object)builder.tagSchema()) ? STYLED_SCHEMA_POST_TAGS : builder.postTags(), BoundaryScannerType.DEFAULT.equals((Object)builder.boundaryScannerType()) ? null : builder.boundaryScannerType(), builder.boundaryScannerLocale(), builder.fragmenterType(), builder.phraseLimit(), builder.encoder() != null ? (HighlighterEncoder.HTML.equals((Object)builder.encoder()) ? HTML_ENCODER : DEFAULT_ENCODER) : null);
    }

    protected LuceneAbstractSearchHighlighter(BoundaryScannerType scannerType) {
        this(Collections.emptySet(), SimpleBoundaryScanner.DEFAULT_BOUNDARY_CHARS, 20, 100, 0, 5, false, DEFAULT_PRE_TAGS, DEFAULT_POST_TAGS, scannerType, Locale.ROOT, HighlighterFragmenter.SPAN, 256, DEFAULT_ENCODER);
    }

    protected LuceneAbstractSearchHighlighter(Set<String> indexNames, Character[] boundaryChars, Integer boundaryMaxScan, Integer fragmentSize, Integer noMatchSize, Integer numberOfFragments, Boolean orderByScore, List<String> preTags, List<String> postTags, BoundaryScannerType boundaryScannerType, Locale boundaryScannerLocale, HighlighterFragmenter fragmenterType, Integer phraseLimit, Encoder encoder) {
        this.indexNames = indexNames;
        this.boundaryChars = boundaryChars;
        this.boundaryMaxScan = boundaryMaxScan;
        this.fragmentSize = fragmentSize;
        this.noMatchSize = noMatchSize;
        this.numberOfFragments = numberOfFragments;
        this.orderByScore = orderByScore;
        this.preTags = preTags;
        this.postTags = postTags;
        this.boundaryScannerType = boundaryScannerType;
        this.boundaryScannerLocale = boundaryScannerLocale;
        this.fragmenterType = fragmenterType;
        this.phraseLimit = phraseLimit;
        this.encoder = encoder;
    }

    public static LuceneAbstractSearchHighlighter from(LuceneSearchIndexScope<?> scope, SearchHighlighter highlighter) {
        if (!(highlighter instanceof LuceneAbstractSearchHighlighter)) {
            throw log.cannotMixLuceneSearchQueryWithOtherQueryHighlighters(highlighter);
        }
        LuceneAbstractSearchHighlighter casted = (LuceneAbstractSearchHighlighter)highlighter;
        if (!scope.hibernateSearchIndexNames().equals(casted.indexNames())) {
            throw log.queryHighlighterDefinedOnDifferentIndexes(highlighter, casted.indexNames(), scope.hibernateSearchIndexNames());
        }
        return casted;
    }

    public static LuceneAbstractSearchHighlighter defaultHighlighter() {
        return LuceneUnifiedSearchHighlighter.DEFAULTS;
    }

    public LuceneAbstractSearchHighlighter withFallback(LuceneAbstractSearchHighlighter fallback) {
        Contracts.assertNotNull((Object)fallback, (String)"fallback highlighter");
        if (!this.type().equals((Object)fallback.type())) {
            throw log.cannotMixDifferentHighlighterTypesAtOverrideLevel(this.type(), fallback.type());
        }
        return this.createHighlighterSameType(this.indexNames, this.boundaryChars != null && this.boundaryChars.length != 0 ? this.boundaryChars : fallback.boundaryChars, this.boundaryMaxScan != null ? this.boundaryMaxScan : fallback.boundaryMaxScan, this.fragmentSize != null ? this.fragmentSize : fallback.fragmentSize, this.noMatchSize != null ? this.noMatchSize : fallback.noMatchSize, this.numberOfFragments != null ? this.numberOfFragments : fallback.numberOfFragments, this.orderByScore != null ? this.orderByScore : fallback.orderByScore, this.preTags != null && !this.preTags.isEmpty() ? this.preTags : fallback.preTags, this.postTags != null && !this.postTags.isEmpty() ? this.postTags : fallback.postTags, this.boundaryScannerType != null ? this.boundaryScannerType : fallback.boundaryScannerType, this.boundaryScannerLocale != null ? this.boundaryScannerLocale : fallback.boundaryScannerLocale, this.fragmenterType != null ? this.fragmenterType : fallback.fragmenterType, this.phraseLimit != null ? this.phraseLimit : fallback.phraseLimit, this.encoder != null ? this.encoder : fallback.encoder);
    }

    protected abstract LuceneAbstractSearchHighlighter createHighlighterSameType(Set<String> var1, Character[] var2, Integer var3, Integer var4, Integer var5, Integer var6, Boolean var7, List<String> var8, List<String> var9, BoundaryScannerType var10, Locale var11, HighlighterFragmenter var12, Integer var13, Encoder var14);

    public abstract LuceneAbstractSearchHighlighter withFallbackDefaults();

    public Set<String> indexNames() {
        return this.indexNames;
    }

    public abstract <A> Values<A> createValues(String var1, String var2, String var3, Analyzer var4, ProjectionExtractContext var5, ProjectionAccumulator<String, ?, A, List<String>> var6);

    public abstract SearchHighlighterType type();

    public void request(ProjectionRequestContext context, String absoluteFieldPath) {
    }

    public static class Builder
    extends SearchHighlighterBuilder {
        private final LuceneSearchIndexScope<?> scope;

        public Builder(LuceneSearchIndexScope<?> scope) {
            this.scope = scope;
        }

        public SearchHighlighterBuilder fragmentSize(Integer fragmentSize) {
            if (SearchHighlighterType.UNIFIED.equals((Object)this.type())) {
                throw log.unifiedHighlighterFragmentSizeNotSupported();
            }
            return super.fragmentSize(fragmentSize);
        }

        public LuceneAbstractSearchHighlighter build() {
            switch (this.type) {
                case UNIFIED: {
                    return new LuceneUnifiedSearchHighlighter(this);
                }
                case PLAIN: {
                    return new LucenePlainSearchHighlighter(this);
                }
                case FAST_VECTOR: {
                    return new LuceneFastVectorSearchHighlighter(this);
                }
            }
            throw new IllegalStateException("Unknown highlighter type.");
        }
    }
}

