/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneNestablePredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneCommonMinimumShouldMatchConstraints;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneCommonQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.common.spi.SearchIndexSchemaElementContextHelper;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.engine.search.predicate.spi.CommonQueryStringPredicateBuilder;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class LuceneCommonQueryStringPredicate
extends AbstractLuceneNestablePredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<String> nestedPathHierarchy;
    private final List<String> fieldPaths;
    private final Builder builder;

    protected LuceneCommonQueryStringPredicate(Builder builder) {
        super(builder);
        this.nestedPathHierarchy = builder.firstFieldState.field().nestedPathHierarchy();
        this.fieldPaths = new ArrayList<String>(builder.fieldStates.keySet());
        this.builder = builder;
    }

    static void checkFieldsAreAcceptable(String queryName, Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStates) {
        ArrayList<String> badFields = new ArrayList<String>();
        for (LuceneCommonQueryStringPredicateBuilderFieldState state : fieldStates.values()) {
            if (state.field().type().searchAnalyzerOrNormalizer() != null) continue;
            badFields.add(String.format(Locale.ROOT, "{'%s':%s}", state.field().absolutePath(), state.field().type().valueClass()));
        }
        if (!badFields.isEmpty()) {
            throw new SearchException(queryName + " queries are not allowed for non-string fields. Fields violating this constraint are: " + String.valueOf(badFields));
        }
    }

    static PredicateRequestContext contextForField(LuceneCommonQueryStringPredicateBuilderFieldState state) {
        List nestedPathHierarchy = state.field().nestedPathHierarchy();
        String expectedNestedPath = nestedPathHierarchy.isEmpty() ? null : (String)nestedPathHierarchy.get(nestedPathHierarchy.size() - 1);
        return PredicateRequestContext.withoutSession().withNestedPath(expectedNestedPath);
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        return this.builder.buildQuery(context);
    }

    @Override
    protected List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    protected List<String> getFieldPathsForErrorMessage() {
        return this.fieldPaths;
    }

    public static abstract class Builder
    extends AbstractLuceneSearchPredicate.AbstractBuilder
    implements CommonQueryStringPredicateBuilder {
        private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
        private LuceneCommonQueryStringPredicateBuilderFieldState firstFieldState;
        private final Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStates = new LinkedHashMap<String, LuceneCommonQueryStringPredicateBuilderFieldState>();
        protected BooleanOperator defaultOperator = BooleanOperator.OR;
        protected String queryString;
        private Analyzer overrideAnalyzer;
        private boolean ignoreAnalyzer = false;
        protected final LuceneCommonMinimumShouldMatchConstraints minimumShouldMatchConstraints;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
            this.analysisDefinitionRegistry = scope.analysisDefinitionRegistry();
            this.minimumShouldMatchConstraints = new LuceneCommonMinimumShouldMatchConstraints();
        }

        public void defaultOperator(BooleanOperator operator) {
            this.defaultOperator = operator;
        }

        public CommonQueryStringPredicateBuilder.FieldState field(String fieldPath) {
            LuceneCommonQueryStringPredicateBuilderFieldState fieldState = this.fieldStates.get(fieldPath);
            if (fieldState == null) {
                fieldState = (LuceneCommonQueryStringPredicateBuilderFieldState)this.scope.fieldQueryElement(fieldPath, this.typeKey());
                if (this.firstFieldState == null) {
                    this.firstFieldState = fieldState;
                } else {
                    SearchIndexSchemaElementContextHelper.checkNestedDocumentPathCompatibility(this.firstFieldState.field(), fieldState.field());
                }
                this.fieldStates.put(fieldPath, fieldState);
            }
            return fieldState;
        }

        public void queryString(String queryString) {
            this.queryString = queryString;
        }

        public void analyzer(String analyzerName) {
            this.overrideAnalyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
            if (this.overrideAnalyzer == null) {
                throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexNames((Set)this.scope.hibernateSearchIndexNames()));
            }
        }

        public void skipAnalysis() {
            this.ignoreAnalyzer = true;
        }

        public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
            this.minimumShouldMatchConstraints.minimumShouldMatchNumber(ignoreConstraintCeiling, matchingClausesNumber);
        }

        public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
            this.minimumShouldMatchConstraints.minimumShouldMatchPercent(ignoreConstraintCeiling, matchingClausesPercent);
        }

        protected Query addMatchAllForBoolMustNotOnly(Query query) {
            if (query instanceof BooleanQuery) {
                BooleanQuery booleanQuery = (BooleanQuery)query;
                long notMustNot = booleanQuery.clauses().stream().map(BooleanClause::getOccur).filter(Predicate.not(arg_0 -> BooleanClause.Occur.MUST_NOT.equals(arg_0))).count();
                if (notMustNot == 0L && !booleanQuery.clauses().isEmpty()) {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    for (BooleanClause clause : booleanQuery.clauses()) {
                        builder.add(clause);
                    }
                    builder.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST));
                    query = builder.build();
                }
            }
            return query;
        }

        protected abstract Query buildQuery(PredicateRequestContext var1);

        protected abstract SearchQueryElementTypeKey<LuceneCommonQueryStringPredicateBuilderFieldState> typeKey();

        protected Analyzer buildAnalyzer() {
            if (this.ignoreAnalyzer) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            if (this.overrideAnalyzer != null) {
                return this.overrideAnalyzer;
            }
            if (this.fieldStates.size() == 1) {
                return this.fieldStates.values().iterator().next().field().type().searchAnalyzerOrNormalizer();
            }
            ScopedAnalyzer.Builder builder = new ScopedAnalyzer.Builder();
            for (LuceneCommonQueryStringPredicateBuilderFieldState state : this.fieldStates.values()) {
                builder.setAnalyzer(state.field().absolutePath(), state.field().type().searchAnalyzerOrNormalizer());
            }
            return builder.build();
        }

        protected Map<String, Float> buildWeights() {
            LinkedHashMap<String, Float> weights = new LinkedHashMap<String, Float>();
            for (LuceneCommonQueryStringPredicateBuilderFieldState state : this.fieldStates.values()) {
                Float boost = state.boost();
                if (boost == null) {
                    boost = Float.valueOf(1.0f);
                }
                weights.put(state.field().absolutePath(), boost);
            }
            return weights;
        }

        protected Map<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStateLookup() {
            HashMap<String, LuceneCommonQueryStringPredicateBuilderFieldState> fieldStatesRemapped = new HashMap<String, LuceneCommonQueryStringPredicateBuilderFieldState>();
            for (LuceneCommonQueryStringPredicateBuilderFieldState state : this.fieldStates.values()) {
                fieldStatesRemapped.put(state.field().absolutePath(), state);
            }
            return fieldStatesRemapped;
        }
    }
}

