/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaNestingContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;

class NotifyingNestingContext
implements IndexSchemaNestingContext {
    private final IndexSchemaNestingContext delegate;
    private final IndexSchemaContributionListener listener;

    NotifyingNestingContext(IndexSchemaNestingContext delegate, IndexSchemaContributionListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    @Override
    public <T> T nest(String relativeName, IndexSchemaNestingContext.LeafFactory<T> factory) {
        return (T)this.delegate.nest(relativeName, (String prefixedName, IndexFieldInclusion inclusion) -> {
            if (IndexFieldInclusion.INCLUDED.equals((Object)inclusion)) {
                this.listener.onSchemaContributed();
            }
            return factory.create(prefixedName, inclusion);
        });
    }

    @Override
    public <T> T nest(String relativeName, IndexSchemaNestingContext.CompositeFactory<T> factory) {
        return (T)this.delegate.nest(relativeName, (String prefixedName, IndexFieldInclusion inclusion, IndexSchemaNestingContext nestedNestingContext) -> {
            if (IndexFieldInclusion.INCLUDED.equals((Object)inclusion)) {
                this.listener.onSchemaContributed();
            }
            return factory.create(prefixedName, inclusion, nestedNestingContext);
        });
    }

    @Override
    public <T> T nestTemplate(IndexSchemaNestingContext.TemplateFactory<T> factory) {
        return (T)this.delegate.nestTemplate((inclusion, prefix) -> {
            if (IndexFieldInclusion.INCLUDED.equals((Object)inclusion)) {
                this.listener.onSchemaContributed();
            }
            return factory.create(inclusion, prefix);
        });
    }
}

