/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.FieldSortMissingValueBehaviorStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.dsl.spi.AbstractSortThenStep;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;

public class FieldSortOptionsStepImpl<PDF extends SearchPredicateFactory>
extends AbstractSortThenStep
implements FieldSortOptionsStep<FieldSortOptionsStepImpl<PDF>, PDF>,
FieldSortMissingValueBehaviorStep<FieldSortOptionsStepImpl<PDF>> {
    private final SearchSortDslContext<?, ? extends PDF> dslContext;
    private final FieldSortBuilder builder;

    public FieldSortOptionsStepImpl(SearchSortDslContext<?, ? extends PDF> dslContext, String absoluteFieldPath) {
        super(dslContext);
        this.dslContext = dslContext;
        this.builder = dslContext.builderFactory().field(absoluteFieldPath);
    }

    @Override
    public FieldSortOptionsStepImpl<PDF> order(SortOrder order) {
        this.builder.order(order);
        return this;
    }

    @Override
    public FieldSortOptionsStepImpl<PDF> mode(SortMode mode) {
        this.builder.mode(mode);
        return this;
    }

    @Override
    public FieldSortMissingValueBehaviorStep<FieldSortOptionsStepImpl<PDF>> missing() {
        return this;
    }

    @Override
    public FieldSortOptionsStepImpl<PDF> filter(Function<? super PDF, ? extends PredicateFinalStep> clauseContributor) {
        SearchPredicate predicate = clauseContributor.apply(this.dslContext.predicateFactory()).toPredicate();
        return this.filter(predicate);
    }

    @Override
    public FieldSortOptionsStepImpl<PDF> filter(SearchPredicate searchPredicate) {
        this.builder.filter(searchPredicate);
        return this;
    }

    @Override
    public FieldSortOptionsStepImpl<PDF> first() {
        this.builder.missingFirst();
        return this;
    }

    @Override
    public FieldSortOptionsStepImpl<PDF> last() {
        this.builder.missingLast();
        return this;
    }

    @Override
    public FieldSortOptionsStepImpl<PDF> use(Object value, ValueConvert convert) {
        this.builder.missingAs(value, convert);
        return this;
    }

    @Override
    protected SearchSort build() {
        return this.builder.build();
    }
}

