/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.search.engine.cfg.impl.AbstractConfigurationProperty;

final class DefaultedConfigurationProperty<T>
extends AbstractConfigurationProperty<T> {
    private final Function<Object, T> converter;
    private final Supplier<T> defaultValueSupplier;

    DefaultedConfigurationProperty(String key, Function<Object, T> converter, Supplier<T> defaultValueSupplier) {
        super(key);
        this.converter = converter;
        this.defaultValueSupplier = defaultValueSupplier;
    }

    @Override
    <R> R convert(Optional<?> rawValue, Function<T, R> transform) {
        T defaultedValue = rawValue.map(this.converter).orElseGet(this.defaultValueSupplier);
        return transform.apply(defaultedValue);
    }
}

