/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import org.hibernate.BaseSessionEventListener;
import org.hibernate.HibernateException;
import org.hibernate.SessionEventListener;
import org.hibernate.Transaction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.mapper.orm.impl.InTransactionWorkQueueSynchronization;
import org.hibernate.search.mapper.orm.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.mapper.orm.impl.TransientReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.spi.HibernateOrmMapping;
import org.hibernate.search.mapper.orm.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.session.spi.SearchSessionImplementor;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.Service;

public class HibernateSearchContextService
implements Service,
AutoCloseable {
    private static final String SEARCH_SESSION_KEY = HibernateSearchContextService.class.getName() + "#SEARCH_SESSION_KEY";
    private static final String WORK_PLAN_PER_TRANSACTION_MAP_KEY = HibernateSearchContextService.class.getName() + "#WORK_PLAN_PER_TRANSACTION_KEY";
    private volatile SearchIntegration integration;
    private volatile HibernateOrmMapping mapping;
    private boolean enlistInTransaction = false;

    @Override
    public void close() {
        if (this.integration != null) {
            this.integration.close();
        }
    }

    public void initialize(SearchIntegration integration, HibernateOrmMapping mapping) {
        this.integration = integration;
        this.mapping = mapping;
    }

    public SearchIntegration getIntegration() {
        if (this.integration != null) {
            return this.integration;
        }
        throw ((Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup())).hibernateSearchNotInitialized();
    }

    public HibernateOrmMapping getMapping() {
        if (this.mapping != null) {
            return this.mapping;
        }
        throw ((Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup())).hibernateSearchNotInitialized();
    }

    public SearchSessionImplementor getSearchSession(SessionImplementor sessionImplementor) {
        SearchSessionImplementor searchSession;
        TransientReference<SearchSessionImplementor> reference = (TransientReference<SearchSessionImplementor>)sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
        SearchSessionImplementor searchSessionImplementor = searchSession = reference == null ? null : (SearchSessionImplementor)reference.get();
        if (searchSession == null) {
            searchSession = this.getMapping().createSession((EntityManager)sessionImplementor);
            reference = new TransientReference<SearchSessionImplementor>(searchSession);
            sessionImplementor.setProperty(SEARCH_SESSION_KEY, reference);
            sessionImplementor.getEventListenerManager().addListener(new SessionEventListener[]{new SearchSessionClosingListener(sessionImplementor)});
        }
        return searchSession;
    }

    public PojoWorkPlan getCurrentWorkPlan(SessionImplementor sessionImplementor) {
        SearchSessionImplementor searchSession = this.getSearchSession(sessionImplementor);
        if (sessionImplementor.isTransactionInProgress()) {
            PojoWorkPlan workPlan;
            HashMap<Transaction, PojoWorkPlan> workPlanPerTransaction;
            Transaction transactionIdentifier = sessionImplementor.accessTransaction();
            TransientReference reference = (TransientReference)sessionImplementor.getProperties().get(WORK_PLAN_PER_TRANSACTION_MAP_KEY);
            HashMap<Transaction, PojoWorkPlan> hashMap = workPlanPerTransaction = reference == null ? null : (HashMap<Transaction, PojoWorkPlan>)reference.get();
            if (workPlanPerTransaction == null) {
                workPlanPerTransaction = new HashMap<Transaction, PojoWorkPlan>();
                reference = new TransientReference(workPlanPerTransaction);
                sessionImplementor.setProperty(WORK_PLAN_PER_TRANSACTION_MAP_KEY, reference);
            }
            if ((workPlan = (PojoWorkPlan)workPlanPerTransaction.get(transactionIdentifier)) == null) {
                AutomaticIndexingSynchronizationStrategy synchronizationStrategy = searchSession.getAutomaticIndexingSynchronizationStrategy();
                workPlan = searchSession.createWorkPlan(synchronizationStrategy.getDocumentCommitStrategy(), synchronizationStrategy.getDocumentRefreshStrategy());
                workPlanPerTransaction.put(transactionIdentifier, workPlan);
                Synchronization txSync = this.createTransactionWorkQueueSynchronization(workPlan, workPlanPerTransaction, transactionIdentifier, synchronizationStrategy);
                this.registerSynchronization(sessionImplementor, txSync);
            }
            return workPlan;
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private Synchronization createTransactionWorkQueueSynchronization(PojoWorkPlan workPlan, Map<Transaction, PojoWorkPlan> workPlanPerTransaction, Object transactionIdentifier, AutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        if (this.enlistInTransaction) {
            return new InTransactionWorkQueueSynchronization(workPlan, workPlanPerTransaction, transactionIdentifier, synchronizationStrategy);
        }
        return new PostTransactionWorkQueueSynchronization(workPlan, workPlanPerTransaction, transactionIdentifier, synchronizationStrategy);
    }

    private void registerSynchronization(SessionImplementor sessionImplementor, Synchronization synchronization) {
        ActionQueue actionQueue = sessionImplementor.getActionQueue();
        SynchronizationAdapter adapter = new SynchronizationAdapter(synchronization);
        boolean isLocal = this.isLocalTransaction(sessionImplementor);
        if (isLocal) {
            actionQueue.registerProcess((BeforeTransactionCompletionProcess)adapter);
        } else {
            actionQueue.registerProcess((BeforeTransactionCompletionProcess)adapter);
            sessionImplementor.accessTransaction().registerSynchronization((Synchronization)adapter);
        }
        actionQueue.registerProcess((AfterTransactionCompletionProcess)adapter);
    }

    private boolean isLocalTransaction(SessionImplementor sessionImplementor) {
        return !sessionImplementor.getTransactionCoordinator().getTransactionCoordinatorBuilder().isJta();
    }

    private static class SynchronizationAdapter
    implements Synchronization,
    BeforeTransactionCompletionProcess,
    AfterTransactionCompletionProcess {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
        private final Synchronization delegate;
        private boolean beforeExecuted = false;
        private boolean afterExecuted = false;

        SynchronizationAdapter(Synchronization delegate) {
            this.delegate = delegate;
        }

        public void beforeCompletion() {
            this.doBeforeCompletion();
        }

        public void afterCompletion(int status) {
            log.tracef("Transaction's afterCompletion is expected to be executed through the AfterTransactionCompletionProcess interface, ignoring: %s", this.delegate);
        }

        public void doBeforeTransactionCompletion(SessionImplementor sessionImplementor) {
            try {
                this.doBeforeCompletion();
            }
            catch (Exception e) {
                throw new HibernateException("Error while indexing in Hibernate Search (before transaction completion)", (Throwable)e);
            }
        }

        public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor sessionImplementor) {
            try {
                this.doAfterCompletion(success ? 3 : 4);
            }
            catch (Exception e) {
                throw new HibernateException("Error while indexing in Hibernate Search (after transaction completion)", (Throwable)e);
            }
        }

        private void doBeforeCompletion() {
            if (this.beforeExecuted) {
                log.tracef("Transaction's beforeCompletion() phase already been processed, ignoring: %s", this.delegate);
            } else {
                this.delegate.beforeCompletion();
                this.beforeExecuted = true;
            }
        }

        private void doAfterCompletion(int status) {
            if (this.afterExecuted) {
                log.tracef("Transaction's afterCompletion() phase already been processed, ignoring: %s", this.delegate);
            } else {
                this.delegate.afterCompletion(status);
                this.afterExecuted = true;
            }
        }
    }

    private static class SearchSessionClosingListener
    extends BaseSessionEventListener {
        private final SessionImplementor sessionImplementor;

        private SearchSessionClosingListener(SessionImplementor sessionImplementor) {
            this.sessionImplementor = sessionImplementor;
        }

        public void end() {
            SearchSessionImplementor searchSession;
            TransientReference reference = (TransientReference)this.sessionImplementor.getProperties().get(SEARCH_SESSION_KEY);
            SearchSessionImplementor searchSessionImplementor = searchSession = reference == null ? null : (SearchSessionImplementor)reference.get();
            if (searchSession != null) {
                searchSession.close();
            }
        }
    }
}

