/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.context.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.loading.spi.DefaultProjectionHitMapper;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderBuilder;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.pojo.search.PojoReference;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchScopeDelegate;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateOrmLoadingContext<E>
implements LoadingContext<PojoReference, E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionImplementor sessionImplementor;
    private final ProjectionHitMapper<PojoReference, E> projectionHitMapper;
    private final MutableEntityLoadingOptions loadingOptions;

    private HibernateOrmLoadingContext(SessionImplementor sessionImplementor, ProjectionHitMapper<PojoReference, E> projectionHitMapper, MutableEntityLoadingOptions loadingOptions) {
        this.sessionImplementor = sessionImplementor;
        this.projectionHitMapper = projectionHitMapper;
        this.loadingOptions = loadingOptions;
    }

    public ProjectionHitMapper<PojoReference, E> getProjectionHitMapper() {
        try {
            this.sessionImplementor.checkOpen();
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionIsClosed(e);
        }
        return this.projectionHitMapper;
    }

    public SessionImplementor getSessionImplementor() {
        return this.sessionImplementor;
    }

    public MutableEntityLoadingOptions getLoadingOptions() {
        return this.loadingOptions;
    }

    public static final class Builder<E>
    implements LoadingContextBuilder<PojoReference, E> {
        private final SessionImplementor sessionImplementor;
        private final PojoSearchScopeDelegate<?, ?> scopeDelegate;
        private final EntityLoaderBuilder<E> entityLoaderBuilder;
        private final MutableEntityLoadingOptions loadingOptions;

        public Builder(SessionImplementor sessionImplementor, PojoSearchScopeDelegate<?, ?> scopeDelegate, EntityLoaderBuilder<E> entityLoaderBuilder, MutableEntityLoadingOptions loadingOptions) {
            this.sessionImplementor = sessionImplementor;
            this.scopeDelegate = scopeDelegate;
            this.entityLoaderBuilder = entityLoaderBuilder;
            this.loadingOptions = loadingOptions;
        }

        public LoadingContext<PojoReference, E> build() {
            DefaultProjectionHitMapper projectionHitMapper = new DefaultProjectionHitMapper(arg_0 -> this.scopeDelegate.toPojoReference(arg_0), this.entityLoaderBuilder.build(this.loadingOptions));
            return new HibernateOrmLoadingContext(this.sessionImplementor, (ProjectionHitMapper)projectionHitMapper, this.loadingOptions);
        }
    }
}

