/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingEntityFailureContext;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingFailureContext;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingFailureHandler;
import org.hibernate.search.mapper.orm.massindexing.MassIndexingMonitor;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingSessionContext;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class MassIndexingNotifier {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final MassIndexingFailureHandler failureHandler;
    private final MassIndexingMonitor monitor;
    private final AtomicReference<RecordedEntityIndexingFailure> entityIndexingFirstFailure = new AtomicReference<Object>(null);
    private final LongAdder entityIndexingFailureCount = new LongAdder();

    MassIndexingNotifier(MassIndexingFailureHandler failureHandler, MassIndexingMonitor monitor) {
        this.failureHandler = failureHandler;
        this.monitor = monitor;
    }

    void notifyAddedTotalCount(long totalCount) {
        this.monitor.addToTotalCount(totalCount);
    }

    void notifyRunnableFailure(Exception exception, String operation) {
        MassIndexingFailureContext.Builder contextBuilder = MassIndexingFailureContext.builder();
        contextBuilder.throwable(exception);
        contextBuilder.failingOperation(operation);
        this.failureHandler.handle(contextBuilder.build());
    }

    void notifyEntitiesLoaded(int size) {
        this.monitor.entitiesLoaded(size);
    }

    void notifyDocumentBuilt() {
        this.monitor.documentsBuilt(1L);
    }

    void notifyDocumentsAdded(int size) {
        this.monitor.documentsAdded(size);
    }

    <T> void notifyEntityIndexingFailure(HibernateOrmMassIndexingIndexedTypeContext<T> type, HibernateOrmMassIndexingSessionContext sessionContext, T entity, Exception exception) {
        RecordedEntityIndexingFailure recordedFailure = new RecordedEntityIndexingFailure(exception);
        this.entityIndexingFirstFailure.compareAndSet(null, recordedFailure);
        this.entityIndexingFailureCount.increment();
        MassIndexingEntityFailureContext.Builder contextBuilder = MassIndexingEntityFailureContext.builder();
        contextBuilder.throwable(exception);
        contextBuilder.failingOperation(log.massIndexerIndexingInstance(type.jpaEntityName()));
        EntityReference entityReference = this.extractReferenceOrSuppress(type, sessionContext, entity, exception);
        if (entityReference != null) {
            contextBuilder.entityReference(entityReference);
            recordedFailure.entityReference = entityReference;
        }
        this.failureHandler.handle(contextBuilder.build());
    }

    void notifyIndexingCompletedSuccessfully() {
        this.monitor.indexingCompleted();
        SearchException entityIndexingException = this.createEntityIndexingExceptionOrNull();
        if (entityIndexingException != null) {
            throw entityIndexingException;
        }
    }

    void notifyIndexingCompletedWithInterruption() {
        log.interruptedBatchIndexing();
        this.notifyIndexingCompletedSuccessfully();
    }

    void notifyIndexingCompletedWithFailure(Throwable throwable) {
        this.monitor.indexingCompleted();
        SearchException entityIndexingException = this.createEntityIndexingExceptionOrNull();
        if (entityIndexingException != null) {
            throwable.addSuppressed((Throwable)entityIndexingException);
        }
        MassIndexingFailureContext.Builder contextBuilder = MassIndexingFailureContext.builder();
        contextBuilder.throwable(throwable);
        contextBuilder.failingOperation(log.massIndexerOperation());
        this.failureHandler.handle(contextBuilder.build());
    }

    private SearchException createEntityIndexingExceptionOrNull() {
        RecordedEntityIndexingFailure firstFailure = this.entityIndexingFirstFailure.get();
        if (firstFailure == null) {
            return null;
        }
        return log.massIndexingEntityFailures(this.entityIndexingFailureCount.longValue(), firstFailure.entityReference, firstFailure.throwable.getMessage(), firstFailure.throwable);
    }

    private <T> EntityReference extractReferenceOrSuppress(HibernateOrmMassIndexingIndexedTypeContext<T> type, HibernateOrmMassIndexingSessionContext sessionContext, Object entity, Throwable throwable) {
        try {
            SessionImplementor session = sessionContext.session();
            Serializable identifier = session.getIdentifier(entity);
            return (EntityReference)EntityReferenceFactory.safeCreateEntityReference(sessionContext.entityReferenceFactory(), (String)type.jpaEntityName(), (Object)identifier, throwable::addSuppressed);
        }
        catch (RuntimeException e) {
            throwable.addSuppressed(e);
            return null;
        }
    }

    private static class RecordedEntityIndexingFailure {
        private Throwable throwable;
        private EntityReference entityReference;

        RecordedEntityIndexingFailure(Throwable throwable) {
            this.throwable = throwable;
        }
    }
}

