/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmQueryLoaderImpl;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.ConditionalExpression;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmQueryLoader;
import org.hibernate.search.mapper.orm.loading.spi.LoadingTypeContext;
import org.hibernate.search.util.common.AssertionFailure;

public abstract class AbstractHibernateOrmLoadingStrategy<E, I>
implements HibernateOrmEntityLoadingStrategy<E, I> {
    private final SessionFactoryImplementor sessionFactory;
    private final EntityMappingType rootEntityMappingType;
    private final TypeQueryFactory<E, I> queryFactory;

    AbstractHibernateOrmLoadingStrategy(SessionFactoryImplementor sessionFactory, EntityMappingType rootEntityMappingType, TypeQueryFactory<E, I> queryFactory) {
        this.sessionFactory = sessionFactory;
        this.rootEntityMappingType = rootEntityMappingType;
        this.queryFactory = queryFactory;
    }

    @Override
    public HibernateOrmQueryLoader<E, I> createQueryLoader(List<LoadingTypeContext<? extends E>> typeContexts, List<ConditionalExpression> conditionalExpressions) {
        return this.createQueryLoader(typeContexts, conditionalExpressions, null);
    }

    @Override
    public HibernateOrmQueryLoader<E, I> createQueryLoader(List<LoadingTypeContext<? extends E>> typeContexts, List<ConditionalExpression> conditionalExpressions, String order) {
        Set<Class<Class>> includedTypesFilter;
        if (HibernateOrmUtils.targetsAllConcreteSubTypes(this.sessionFactory, this.rootEntityMappingType, typeContexts)) {
            includedTypesFilter = Collections.emptySet();
        } else {
            includedTypesFilter = new HashSet(typeContexts.size());
            for (LoadingTypeContext<E> typeContext : typeContexts) {
                includedTypesFilter.add(typeContext.typeIdentifier().javaClass());
            }
        }
        if (!conditionalExpressions.isEmpty() || order != null) {
            if (typeContexts.size() != 1) {
                throw new AssertionFailure("conditional/order expression is always defined on a single type");
            }
            EntityMappingType entityMappingType = typeContexts.get(0).entityMappingType();
            return new HibernateOrmQueryLoaderImpl(this.queryFactory, entityMappingType, includedTypesFilter, conditionalExpressions, order);
        }
        return new HibernateOrmQueryLoaderImpl(this.queryFactory, includedTypesFilter);
    }
}

