/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.schema.management.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPreStopContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingStartContext;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.util.common.AssertionFailure;

public class SchemaManagementListener {
    private final SchemaManagementStrategyName strategyName;

    public SchemaManagementListener(SchemaManagementStrategyName strategyName) {
        this.strategyName = strategyName;
    }

    public CompletableFuture<?> onStart(MappingStartContext context, PojoScopeSchemaManager manager) {
        ContextualFailureCollector failureCollector = context.failureCollector();
        switch (this.strategyName) {
            case CREATE: {
                return manager.createIfMissing((FailureCollector)failureCollector, OperationSubmitter.blocking());
            }
            case DROP_AND_CREATE: 
            case DROP_AND_CREATE_AND_DROP: {
                return manager.dropAndCreate((FailureCollector)failureCollector, OperationSubmitter.blocking());
            }
            case CREATE_OR_UPDATE: {
                return manager.createOrUpdate((FailureCollector)failureCollector, OperationSubmitter.blocking());
            }
            case CREATE_OR_VALIDATE: {
                return manager.createOrValidate((FailureCollector)failureCollector, OperationSubmitter.blocking());
            }
            case VALIDATE: {
                return manager.validate((FailureCollector)failureCollector, OperationSubmitter.blocking());
            }
            case NONE: {
                return CompletableFuture.completedFuture(null);
            }
        }
        throw new AssertionFailure("Unexpected schema management strategy: " + String.valueOf((Object)this.strategyName));
    }

    public CompletableFuture<?> onStop(MappingPreStopContext context, PojoScopeSchemaManager manager) {
        ContextualFailureCollector failureCollector = context.failureCollector();
        switch (this.strategyName) {
            case DROP_AND_CREATE_AND_DROP: {
                return manager.dropIfExisting((FailureCollector)failureCollector, OperationSubmitter.blocking());
            }
            case CREATE: 
            case DROP_AND_CREATE: 
            case CREATE_OR_UPDATE: 
            case CREATE_OR_VALIDATE: 
            case VALIDATE: 
            case NONE: {
                return CompletableFuture.completedFuture(null);
            }
        }
        throw new AssertionFailure("Unexpected schema management strategy: " + String.valueOf((Object)this.strategyName));
    }
}

