/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.ZoneOffset;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultZoneOffsetValueBridge
implements ValueBridge<ZoneOffset, Integer> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, Integer> bind(ValueBridgeBindingContext<ZoneOffset> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asInteger().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultZoneOffsetFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public Integer toIndexedValue(ZoneOffset value, ValueBridgeToIndexedValueContext context) {
        return this.toIndexedValue(value);
    }

    @Override
    public ZoneOffset cast(Object value) {
        return (ZoneOffset)value;
    }

    @Override
    public Integer parse(String value) {
        return this.toIndexedValue(ParseUtils.parseZoneOffset((String)value));
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private Integer toIndexedValue(ZoneOffset value) {
        return value == null ? null : Integer.valueOf(value.getTotalSeconds());
    }

    private static class PojoDefaultZoneOffsetFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<Integer, ZoneOffset> {
        private static final PojoDefaultZoneOffsetFromDocumentFieldValueConverter INSTANCE = new PojoDefaultZoneOffsetFromDocumentFieldValueConverter();

        private PojoDefaultZoneOffsetFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(ZoneOffset.class);
        }

        public ZoneOffset convert(Integer value, FromDocumentFieldValueConvertContext context) {
            return value == null ? null : ZoneOffset.ofTotalSeconds(value);
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

