/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.impl;

import java.lang.annotation.Annotation;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.pojo.bridge.mapping.AnnotationBridgeBuilder;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuildContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;

public final class AnnotationInitializingBeanDelegatingBridgeBuilder<B, A extends Annotation>
implements BridgeBuilder<B> {
    private final BeanReference<? extends AnnotationBridgeBuilder> delegateReference;
    private final Class<B> expectedBridgeType;
    private final A annotation;

    public AnnotationInitializingBeanDelegatingBridgeBuilder(BeanReference<? extends AnnotationBridgeBuilder> delegateReference, Class<B> expectedBridgeType, A annotation) {
        this.delegateReference = delegateReference;
        this.expectedBridgeType = expectedBridgeType;
        this.annotation = annotation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegateReference=" + this.delegateReference + ", annotation=" + this.annotation + "]";
    }

    @Override
    public BeanHolder<? extends B> build(BridgeBuildContext buildContext) {
        BeanHolder bridgeHolder;
        try (BeanHolder delegateHolder = this.delegateReference.getBean(buildContext.getBeanProvider());){
            AnnotationBridgeBuilder castedDelegate = (AnnotationBridgeBuilder)delegateHolder.get();
            castedDelegate.initialize(this.annotation);
            bridgeHolder = castedDelegate.build(buildContext);
        }
        this.expectedBridgeType.cast(bridgeHolder.get());
        BeanHolder castedBridgeHolder = bridgeHolder;
        return castedBridgeHolder;
    }
}

