/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexManagerBuildingState;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingAbortedException;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.bridge.impl.BridgeResolver;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoAssociationPathInverter;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.MarkerBuildContextImpl;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexModelBinderImpl;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexedTypeManagerBuilder;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoMappingDelegateImpl;
import org.hibernate.search.mapper.pojo.mapping.impl.ProvidedStringIdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMapper<MPBS extends MappingPartialBuildState>
implements Mapper<MPBS> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ContextualFailureCollector failureCollector;
    private final TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider;
    private final boolean implicitProvidedId;
    private final Function<PojoMappingDelegate, MPBS> wrapperFactory;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final ContainerExtractorBinder extractorBinder;
    private final PojoMappingHelper mappingHelper;
    private final Map<PojoRawTypeModel<?>, PojoIndexedTypeManagerBuilder<?, ?>> indexedTypeManagerBuilders = new LinkedHashMap();
    private boolean closed = false;

    public PojoMapper(MappingBuildContext buildContext, TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider, PojoBootstrapIntrospector introspector, boolean implicitProvidedId, Function<PojoMappingDelegate, MPBS> wrapperFactory) {
        this.failureCollector = buildContext.getFailureCollector();
        this.contributorProvider = contributorProvider;
        this.implicitProvidedId = implicitProvidedId;
        this.wrapperFactory = wrapperFactory;
        this.typeAdditionalMetadataProvider = new PojoTypeAdditionalMetadataProvider(new MarkerBuildContextImpl(buildContext), (FailureCollector)this.failureCollector, contributorProvider);
        TypePatternMatcherFactory typePatternMatcherFactory = new TypePatternMatcherFactory(introspector);
        this.extractorBinder = new ContainerExtractorBinder(buildContext, typePatternMatcherFactory);
        BridgeResolver bridgeResolver = new BridgeResolver(typePatternMatcherFactory);
        PojoIndexModelBinderImpl indexModelBinder = new PojoIndexModelBinderImpl(buildContext, introspector, this.extractorBinder, bridgeResolver, this.typeAdditionalMetadataProvider);
        this.mappingHelper = new PojoMappingHelper((FailureCollector)this.failureCollector, contributorProvider, indexModelBinder);
    }

    public void closeOnFailure() {
        if (!this.closed) {
            this.closed = true;
            try (Closer closer = new Closer();){
                closer.pushAll(PojoIndexedTypeManagerBuilder::closeOnFailure, this.indexedTypeManagerBuilders.values());
            }
        }
    }

    public void addIndexed(MappableTypeModel typeModel, IndexManagerBuildingState<?> indexManagerBuildingState) {
        if (!(typeModel instanceof PojoRawTypeModel)) {
            throw new AssertionFailure("Expected the indexed type model to be an instance of " + PojoRawTypeModel.class + ", got " + typeModel + " instead. There is probably a bug in the mapper implementation");
        }
        PojoRawTypeModel entityTypeModel = (PojoRawTypeModel)typeModel;
        PojoIndexedTypeManagerBuilder builder = new PojoIndexedTypeManagerBuilder(entityTypeModel, this.typeAdditionalMetadataProvider.get(entityTypeModel), this.mappingHelper, indexManagerBuildingState, this.implicitProvidedId ? ProvidedStringIdentifierMapping.get() : null);
        this.indexedTypeManagerBuilders.put(entityTypeModel, builder);
        PojoMappingCollectorTypeNode collector = builder.asCollector();
        this.contributorProvider.forEach((MappableTypeModel)entityTypeModel, c -> c.contributeMapping(collector));
    }

    public MPBS prepareBuild() throws MappingAbortedException {
        PojoMappingDelegateImpl mappingDelegate;
        Set<PojoRawTypeModel<?>> entityTypes = this.computeEntityTypes();
        log.detectedEntityTypes(entityTypes);
        PojoIndexedTypeManagerContainer.Builder indexedTypeManagerContainerBuilder = PojoIndexedTypeManagerContainer.builder();
        PojoContainedTypeManagerContainer.Builder containedTypeManagerContainerBuilder = PojoContainedTypeManagerContainer.builder();
        PojoAssociationPathInverter pathInverter = new PojoAssociationPathInverter(this.typeAdditionalMetadataProvider, this.extractorBinder);
        PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper = new PojoImplicitReindexingResolverBuildingHelper(this.extractorBinder, this.typeAdditionalMetadataProvider, pathInverter, entityTypes);
        try {
            for (PojoIndexedTypeManagerBuilder<?, ?> pojoIndexedTypeManagerBuilder : this.indexedTypeManagerBuilders.values()) {
                pojoIndexedTypeManagerBuilder.preBuild(reindexingResolverBuildingHelper);
            }
            if (this.failureCollector.hasFailure()) {
                throw new MappingAbortedException();
            }
            for (Map.Entry entry : this.indexedTypeManagerBuilders.entrySet()) {
                PojoRawTypeModel typeModel = (PojoRawTypeModel)entry.getKey();
                PojoIndexedTypeManagerBuilder pojoIndexedTypeManagerBuilder = (PojoIndexedTypeManagerBuilder)entry.getValue();
                try {
                    pojoIndexedTypeManagerBuilder.buildAndAddTo(indexedTypeManagerContainerBuilder, reindexingResolverBuildingHelper, this.typeAdditionalMetadataProvider.get(typeModel));
                }
                catch (RuntimeException e) {
                    this.failureCollector.withContext(PojoEventContexts.fromType(typeModel)).add((Throwable)e);
                }
            }
            for (PojoRawTypeModel pojoRawTypeModel : entityTypes) {
                if (pojoRawTypeModel.isAbstract() || this.indexedTypeManagerBuilders.containsKey(pojoRawTypeModel)) continue;
                try {
                    this.buildAndAddContainedTypeManagerTo(containedTypeManagerContainerBuilder, reindexingResolverBuildingHelper, pojoRawTypeModel);
                }
                catch (RuntimeException e) {
                    this.failureCollector.withContext(PojoEventContexts.fromType(pojoRawTypeModel)).add((Throwable)e);
                }
            }
            if (this.failureCollector.hasFailure()) {
                throw new MappingAbortedException();
            }
            mappingDelegate = new PojoMappingDelegateImpl(indexedTypeManagerContainerBuilder.build(), containedTypeManagerContainerBuilder.build());
        }
        catch (RuntimeException | MappingAbortedException e) {
            ((SuppressingCloser)((SuppressingCloser)new SuppressingCloser(e).push(PojoImplicitReindexingResolverBuildingHelper::closeOnFailure, (Object)reindexingResolverBuildingHelper)).push(PojoIndexedTypeManagerContainer.Builder::closeOnFailure, (Object)indexedTypeManagerContainerBuilder)).push(PojoContainedTypeManagerContainer.Builder::closeOnFailure, (Object)containedTypeManagerContainerBuilder);
            throw e;
        }
        this.closed = true;
        try {
            return (MPBS)((MappingPartialBuildState)this.wrapperFactory.apply(mappingDelegate));
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)mappingDelegate);
            throw e;
        }
    }

    private <T> void buildAndAddContainedTypeManagerTo(PojoContainedTypeManagerContainer.Builder containedTypeManagerContainerBuilder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper, PojoRawTypeModel<T> entityType) {
        PojoPathFilterFactory<Set<String>> pathFilterFactory = this.typeAdditionalMetadataProvider.get(entityType).getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(entityType)).getPathFilterFactory();
        Optional<PojoImplicitReindexingResolver<T, Set<String>>> reindexingResolverOptional = reindexingResolverBuildingHelper.build(entityType, pathFilterFactory);
        if (reindexingResolverOptional.isPresent()) {
            PojoContainedTypeManager<T> typeManager = new PojoContainedTypeManager<T>(entityType.getJavaClass(), entityType.getCaster(), reindexingResolverOptional.get());
            log.createdPojoContainedTypeManager(typeManager);
            containedTypeManagerContainerBuilder.add(entityType, typeManager);
        }
    }

    private Set<PojoRawTypeModel<?>> computeEntityTypes() {
        LinkedHashSet<PojoRawTypeModel> entityTypes = new LinkedHashSet<PojoRawTypeModel>();
        Set encounteredTypes = this.contributorProvider.getTypesContributedTo();
        for (MappableTypeModel mappableTypeModel : encounteredTypes) {
            PojoRawTypeModel pojoRawTypeModel = (PojoRawTypeModel)mappableTypeModel;
            if (!this.typeAdditionalMetadataProvider.get(pojoRawTypeModel).isEntity()) continue;
            entityTypes.add(pojoRawTypeModel);
        }
        return Collections.unmodifiableSet(entityTypes);
    }
}

