/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.mapping.impl.AbstractPojoTypeWorkPlan;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;

class PojoContainedTypeWorkPlan<E>
extends AbstractPojoTypeWorkPlan {
    private final PojoContainedTypeManager<E> typeManager;
    private final Map<Object, ContainedEntityWorkPlan> workPlansPerId = new LinkedHashMap<Object, ContainedEntityWorkPlan>();

    PojoContainedTypeWorkPlan(PojoContainedTypeManager<E> typeManager, AbstractPojoSessionContextImplementor sessionContext) {
        super(sessionContext);
        this.typeManager = typeManager;
    }

    @Override
    void add(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeManager.toEntitySupplier(this.sessionContext, entity);
        this.getWork(providedId).add(entitySupplier);
    }

    @Override
    void update(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeManager.toEntitySupplier(this.sessionContext, entity);
        this.getWork(providedId).update(entitySupplier);
    }

    @Override
    void update(Object providedId, Object entity, String ... dirtyPaths) {
        Supplier<E> entitySupplier = this.typeManager.toEntitySupplier(this.sessionContext, entity);
        this.getWork(providedId).update(entitySupplier, dirtyPaths);
    }

    @Override
    void delete(Object providedId, Object entity) {
        Supplier<E> entitySupplier = this.typeManager.toEntitySupplier(this.sessionContext, entity);
        this.getWork(providedId).delete(entitySupplier);
    }

    void resolveDirty(PojoReindexingCollector containingEntityCollector) {
        for (ContainedEntityWorkPlan workPerDocument : this.workPlansPerId.values()) {
            workPerDocument.resolveDirty(containingEntityCollector);
        }
    }

    private ContainedEntityWorkPlan getWork(Object identifier) {
        ContainedEntityWorkPlan work = this.workPlansPerId.get(identifier);
        if (work == null) {
            work = new ContainedEntityWorkPlan();
            this.workPlansPerId.put(identifier, work);
        }
        return work;
    }

    private class ContainedEntityWorkPlan {
        private Supplier<E> entitySupplier;
        private Boolean createdInThisPlan;
        private boolean shouldResolveToReindex;
        private boolean considerAllDirty;
        private Set<String> dirtyPaths;

        private ContainedEntityWorkPlan() {
        }

        void add(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            this.shouldResolveToReindex = true;
            if (this.createdInThisPlan == null) {
                this.createdInThisPlan = true;
            }
        }

        void update(Supplier<E> entitySupplier) {
            this.doUpdate(entitySupplier);
            this.shouldResolveToReindex = true;
            this.considerAllDirty = true;
            this.dirtyPaths = null;
        }

        void update(Supplier<E> entitySupplier, String ... dirtyPaths) {
            this.doUpdate(entitySupplier);
            this.shouldResolveToReindex = true;
            if (!this.considerAllDirty) {
                for (String dirtyPath : dirtyPaths) {
                    this.addDirtyPath(dirtyPath);
                }
            }
        }

        void delete(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (this.createdInThisPlan == null) {
                this.createdInThisPlan = false;
            } else if (this.createdInThisPlan.booleanValue()) {
                this.shouldResolveToReindex = false;
                this.considerAllDirty = false;
                this.dirtyPaths = null;
                this.createdInThisPlan = null;
            }
        }

        void resolveDirty(PojoReindexingCollector containingEntityCollector) {
            if (this.shouldResolveToReindex) {
                this.shouldResolveToReindex = false;
                PojoContainedTypeWorkPlan.this.typeManager.resolveEntitiesToReindex(containingEntityCollector, PojoContainedTypeWorkPlan.this.sessionContext.getRuntimeIntrospector(), this.entitySupplier, this.considerAllDirty ? null : this.dirtyPaths);
            }
        }

        private void doUpdate(Supplier<E> entitySupplier) {
            this.entitySupplier = entitySupplier;
            if (this.createdInThisPlan == null) {
                this.createdInThisPlan = false;
            }
        }

        private void addDirtyPath(String dirtyPath) {
            if (this.dirtyPaths == null) {
                this.dirtyPaths = new HashSet<String>();
            }
            this.dirtyPaths.add(dirtyPath);
        }
    }
}

