/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexSearchScope;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexSearchScopeBuilder;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.engine.search.loading.spi.ObjectLoader;
import org.hibernate.search.engine.search.query.spi.IndexSearchQuery;
import org.hibernate.search.mapper.pojo.mapping.context.spi.AbstractPojoMappingContextImplementor;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoReferenceImpl;
import org.hibernate.search.mapper.pojo.search.PojoReference;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchScopeDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.common.AssertionFailure;

class PojoSearchScopeDelegateImpl<E, O>
implements PojoSearchScopeDelegate<E, O> {
    private final PojoIndexedTypeManagerContainer typeManagers;
    private final Set<PojoIndexedTypeManager<?, ? extends E, ?>> targetedTypeManagers;
    private final AbstractPojoSessionContextImplementor sessionContext;
    private MappedIndexSearchScope<PojoReference, O> delegate;

    PojoSearchScopeDelegateImpl(PojoIndexedTypeManagerContainer typeManagers, Set<PojoIndexedTypeManager<?, ? extends E, ?>> targetedTypeManagers, AbstractPojoSessionContextImplementor sessionContext) {
        this.typeManagers = typeManagers;
        this.targetedTypeManagers = targetedTypeManagers;
        this.sessionContext = sessionContext;
    }

    @Override
    public Set<Class<? extends E>> getIncludedIndexedTypes() {
        return this.targetedTypeManagers.stream().map(PojoIndexedTypeManager::getIndexedJavaClass).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public <T, Q> SearchQueryResultContext<Q> queryAsLoadedObject(ObjectLoader<PojoReference, T> objectLoader, Function<IndexSearchQuery<T>, Q> searchQueryWrapperFactory) {
        return this.getDelegate().queryAsLoadedObject((SessionContextImplementor)this.sessionContext, objectLoader, searchQueryWrapperFactory);
    }

    @Override
    public <Q> SearchQueryResultContext<Q> queryAsReference(Function<IndexSearchQuery<PojoReference>, Q> searchQueryWrapperFactory) {
        return this.getDelegate().queryAsReference((SessionContextImplementor)this.sessionContext, searchQueryWrapperFactory);
    }

    @Override
    public <T, Q> SearchQueryResultContext<Q> queryAsProjection(ObjectLoader<PojoReference, O> objectLoader, Function<IndexSearchQuery<T>, Q> searchQueryWrapperFactory, SearchProjection<T> projection) {
        return this.getDelegate().queryAsProjection((SessionContextImplementor)this.sessionContext, objectLoader, searchQueryWrapperFactory, projection);
    }

    @Override
    public <Q> SearchQueryResultContext<Q> queryAsProjections(ObjectLoader<PojoReference, O> objectLoader, Function<IndexSearchQuery<List<?>>, Q> searchQueryWrapperFactory, SearchProjection<?> ... projections) {
        return this.getDelegate().queryAsProjections((SessionContextImplementor)this.sessionContext, objectLoader, searchQueryWrapperFactory, projections);
    }

    @Override
    public SearchPredicateFactoryContext predicate() {
        return this.getDelegate().predicate();
    }

    @Override
    public SearchSortContainerContext sort() {
        return this.getDelegate().sort();
    }

    @Override
    public SearchProjectionFactoryContext<PojoReference, O> projection() {
        return this.getDelegate().projection();
    }

    private MappedIndexSearchScope<PojoReference, O> getDelegate() {
        AbstractPojoMappingContextImplementor mappingContext = this.sessionContext.getMappingContext();
        if (this.delegate == null) {
            Iterator<PojoIndexedTypeManager<?, E, ?>> iterator = this.targetedTypeManagers.iterator();
            MappedIndexSearchScopeBuilder builder = iterator.next().createSearchScopeBuilder(mappingContext, this::toPojoReference);
            while (iterator.hasNext()) {
                iterator.next().addTo(builder);
            }
            this.delegate = builder.build();
        }
        return this.delegate;
    }

    private PojoReference toPojoReference(DocumentReference documentReference) {
        PojoIndexedTypeManager<?, ?, ?> typeManager = this.typeManagers.getByIndexName(documentReference.getIndexName()).orElseThrow(() -> new AssertionFailure("Document reference " + documentReference + " could not be converted to a PojoReference"));
        Object id = typeManager.getIdentifierMapping().fromDocumentIdentifier(documentReference.getId(), this.sessionContext);
        return new PojoReferenceImpl(typeManager.getIndexedJavaClass(), id);
    }
}

