/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.dependency.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoOtherEntityDependencyContextImpl;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathOriginalTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractPojoBridgedElementDependencyContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoBootstrapIntrospector introspector;
    final BoundPojoModelPath.Walker bindingPathWalker;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private boolean useRootOnly;

    AbstractPojoBridgedElementDependencyContext(PojoBootstrapIntrospector introspector, ContainerExtractorBinder containerExtractorBinder, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider) {
        this.introspector = introspector;
        this.bindingPathWalker = BoundPojoModelPath.walker(containerExtractorBinder);
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
    }

    public void useRootOnly() {
        this.useRootOnly = true;
    }

    public boolean isUseRootOnly() {
        return this.useRootOnly;
    }

    public abstract boolean hasNonRootDependency();

    PojoOtherEntityDependencyContextImpl<?> createOtherEntityDependencyContext(PojoRawTypeModel<?> bridgedType, Class<?> otherEntityClass, PojoModelPathValueNode pathFromOtherEntityTypeToBridgedType) {
        if (!this.typeAdditionalMetadataProvider.get(bridgedType).isEntity()) {
            throw log.cannotDefineOtherEntityDependencyOnNonEntityBridgedType(bridgedType);
        }
        PojoRawTypeModel<?> otherEntityType = this.introspector.getTypeModel(otherEntityClass);
        if (!this.typeAdditionalMetadataProvider.get(otherEntityType).isEntity()) {
            throw log.cannotDefineOtherEntityDependencyFromNonEntityType(otherEntityType);
        }
        BoundPojoModelPathOriginalTypeNode<?> otherEntityRootPath = BoundPojoModelPath.root(otherEntityType);
        BoundPojoModelPathValueNode boundPathFromOtherEntityTypeToBridgedType = (BoundPojoModelPathValueNode)PojoModelPathBinder.bind(otherEntityRootPath, pathFromOtherEntityTypeToBridgedType, this.bindingPathWalker);
        PojoRawTypeModel inverseSideRawType = boundPathFromOtherEntityTypeToBridgedType.getTypeModel().getRawType();
        if (!inverseSideRawType.isSubTypeOf(bridgedType) && !bridgedType.isSubTypeOf(inverseSideRawType)) {
            throw log.incorrectTargetTypeForInverseAssociation(inverseSideRawType, bridgedType);
        }
        return new PojoOtherEntityDependencyContextImpl(this.bindingPathWalker, otherEntityRootPath, boundPathFromOtherEntityTypeToBridgedType);
    }
}

