/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.ZoneId;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.cfg.spi.ValidateUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBridgeBindingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultZoneIdValueBridge
implements ValueBridge<ZoneId, String> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StandardIndexFieldTypeContext<?, String> bind(ValueBridgeBindingContext<ZoneId> context) {
        return (StandardIndexFieldTypeContext)context.getTypeFactory().asString().projectionConverter((FromDocumentFieldValueConverter)PojoDefaultZoneIdFromDocumentFieldValueConverter.INSTANCE);
    }

    @Override
    public String toIndexedValue(ZoneId value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : value.getId();
    }

    @Override
    public ZoneId cast(Object value) {
        return (ZoneId)value;
    }

    @Override
    public String parse(String value) {
        ValidateUtils.validateZoneId((String)value);
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static class PojoDefaultZoneIdFromDocumentFieldValueConverter
    implements FromDocumentFieldValueConverter<String, ZoneId> {
        private static final PojoDefaultZoneIdFromDocumentFieldValueConverter INSTANCE = new PojoDefaultZoneIdFromDocumentFieldValueConverter();

        private PojoDefaultZoneIdFromDocumentFieldValueConverter() {
        }

        public boolean isConvertedTypeAssignableTo(Class<?> superTypeCandidate) {
            return superTypeCandidate.isAssignableFrom(ZoneId.class);
        }

        public ZoneId convert(String value, FromDocumentFieldValueConvertContext context) {
            return value == null ? null : ZoneId.of(value);
        }

        public boolean isCompatibleWith(FromDocumentFieldValueConverter<?, ?> other) {
            return INSTANCE.equals(other);
        }
    }
}

