/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.extractor.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ChainingContainerExtractor;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.extractor.spi.ContainerExtractorRegistry;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ExtractingTypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcherFactory;
import org.hibernate.search.mapper.pojo.util.impl.GenericTypeContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ContainerExtractorBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanProvider beanProvider;
    private final ContainerExtractorRegistry containerExtractorRegistry;
    private final TypePatternMatcherFactory typePatternMatcherFactory;
    private final FirstMatchingExtractorContributor firstMatchingExtractorContributor = new FirstMatchingExtractorContributor();
    private final Map<String, SingleExtractorContributor> extractorContributorCache = new HashMap<String, SingleExtractorContributor>();

    public ContainerExtractorBinder(MappingBuildContext buildContext, ContainerExtractorRegistry containerExtractorRegistry, TypePatternMatcherFactory typePatternMatcherFactory) {
        this.beanProvider = buildContext.getBeanProvider();
        this.containerExtractorRegistry = containerExtractorRegistry;
        this.typePatternMatcherFactory = typePatternMatcherFactory;
        for (String extractorName : containerExtractorRegistry.getDefaults()) {
            this.addDefaultExtractor(extractorName);
        }
    }

    public <C> Optional<BoundContainerExtractorPath<C, ?>> tryBindPath(PojoGenericTypeModel<C> sourceType, ContainerExtractorPath extractorPath) {
        ExtractorResolutionState<C> state = new ExtractorResolutionState<C>(sourceType);
        if (extractorPath.isDefault()) {
            this.firstMatchingExtractorContributor.tryAppend(state);
        } else {
            for (String extractorName : extractorPath.getExplicitExtractorNames()) {
                SingleExtractorContributor extractorContributor = this.getExtractorContributorForName(extractorName);
                if (extractorContributor.tryAppend(state)) continue;
                return Optional.empty();
            }
        }
        return Optional.of(state.build());
    }

    public <C> BoundContainerExtractorPath<C, ?> bindPath(PojoGenericTypeModel<C> sourceType, ContainerExtractorPath extractorPath) {
        ExtractorResolutionState<C> state = new ExtractorResolutionState<C>(sourceType);
        if (extractorPath.isDefault()) {
            this.firstMatchingExtractorContributor.tryAppend(state);
        } else {
            for (String extractorName : extractorPath.getExplicitExtractorNames()) {
                SingleExtractorContributor extractorContributor = this.getExtractorContributorForName(extractorName);
                extractorContributor.append(state);
            }
        }
        return state.build();
    }

    public <C, V> ContainerExtractorHolder<C, V> create(BoundContainerExtractorPath<C, V> boundPath) {
        if (boundPath.getExtractorPath().isEmpty()) {
            throw new AssertionFailure("Received a request to create extractors, but the extractor path was empty. There is probably a bug in Hibernate Search.");
        }
        ChainingContainerExtractor extractor = null;
        ArrayList beanHolders = new ArrayList();
        try {
            for (String extractorName : boundPath.getExtractorPath().getExplicitExtractorNames()) {
                Class<? extends ContainerExtractor> extractorClass = this.containerExtractorRegistry.getForName(extractorName);
                BeanHolder newExtractorHolder = this.beanProvider.getBean(extractorClass);
                beanHolders.add(newExtractorHolder);
                if (extractor == null) {
                    extractor = (ChainingContainerExtractor)newExtractorHolder.get();
                    continue;
                }
                extractor = new ChainingContainerExtractor(extractor, (ContainerExtractor)newExtractorHolder.get());
            }
            return new ContainerExtractorHolder(extractor, beanHolders);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(BeanHolder::close, beanHolders);
            throw e;
        }
    }

    public boolean isDefaultExtractorPath(PojoGenericTypeModel<?> sourceType, ContainerExtractorPath extractorPath) {
        Optional<BoundContainerExtractorPath<?, ?>> boundDefaultExtractorPathOptional = this.tryBindPath(sourceType, ContainerExtractorPath.defaultExtractors());
        return boundDefaultExtractorPathOptional.isPresent() && extractorPath.equals(boundDefaultExtractorPathOptional.get().getExtractorPath());
    }

    private void addDefaultExtractor(String extractorName) {
        SingleExtractorContributor extractorContributor = this.getExtractorContributorForName(extractorName);
        this.firstMatchingExtractorContributor.addCandidate(extractorContributor);
    }

    private SingleExtractorContributor getExtractorContributorForName(String extractorName) {
        return this.extractorContributorCache.computeIfAbsent(extractorName, this::createExtractorContributorForName);
    }

    private SingleExtractorContributor createExtractorContributorForName(String extractorName) {
        ExtractingTypePatternMatcher typePatternMatcher;
        Class<? extends ContainerExtractor> extractorClass = this.containerExtractorRegistry.getForName(extractorName);
        GenericTypeContext typeContext = new GenericTypeContext(extractorClass);
        Type typePattern = typeContext.resolveTypeArgument(ContainerExtractor.class, 0).orElseThrow(() -> log.cannotInferContainerExtractorClassTypePattern(extractorClass));
        Type typeToExtract = typeContext.resolveTypeArgument(ContainerExtractor.class, 1).orElseThrow(() -> log.cannotInferContainerExtractorClassTypePattern(extractorClass));
        try {
            typePatternMatcher = this.typePatternMatcherFactory.createExtractingMatcher(typePattern, typeToExtract);
        }
        catch (UnsupportedOperationException e) {
            throw log.cannotInferContainerExtractorClassTypePattern(extractorClass);
        }
        return new SingleExtractorContributor(typePatternMatcher, extractorName, extractorClass);
    }

    private static class ExtractorResolutionState<C> {
        private final List<String> extractorNames = new ArrayList<String>();
        private final PojoGenericTypeModel<C> sourceType;
        private PojoGenericTypeModel<?> extractedType;

        ExtractorResolutionState(PojoGenericTypeModel<C> sourceType) {
            this.sourceType = sourceType;
            this.extractedType = sourceType;
        }

        void append(String extractorName, PojoGenericTypeModel<?> extractedType) {
            this.extractorNames.add(extractorName);
            this.extractedType = extractedType;
        }

        BoundContainerExtractorPath<C, ?> build() {
            return new BoundContainerExtractorPath(this.sourceType, ContainerExtractorPath.explicitExtractors(this.extractorNames), this.extractedType);
        }
    }

    private static class FirstMatchingExtractorContributor
    implements ExtractorContributor {
        private final List<ExtractorContributor> candidates = new ArrayList<ExtractorContributor>();

        private FirstMatchingExtractorContributor() {
        }

        void addCandidate(ExtractorContributor contributor) {
            this.candidates.add(contributor);
        }

        @Override
        public boolean tryAppend(ExtractorResolutionState<?> state) {
            for (ExtractorContributor extractorContributor : this.candidates) {
                if (!extractorContributor.tryAppend(state)) continue;
                this.tryAppend(state);
                return true;
            }
            return false;
        }
    }

    private class SingleExtractorContributor
    implements ExtractorContributor {
        private final ExtractingTypePatternMatcher typePatternMatcher;
        private final String extractorName;
        private final Class<? extends ContainerExtractor> extractorClass;

        SingleExtractorContributor(ExtractingTypePatternMatcher typePatternMatcher, String extractorName, Class<? extends ContainerExtractor> extractorClass) {
            this.typePatternMatcher = typePatternMatcher;
            this.extractorName = extractorName;
            this.extractorClass = extractorClass;
        }

        @Override
        public boolean tryAppend(ExtractorResolutionState<?> state) {
            Optional<PojoGenericTypeModel<?>> resultTypeOptional = this.typePatternMatcher.extract(((ExtractorResolutionState)state).extractedType);
            if (resultTypeOptional.isPresent()) {
                state.append(this.extractorName, resultTypeOptional.get());
                return true;
            }
            return false;
        }

        void append(ExtractorResolutionState<?> state) {
            if (!this.tryAppend(state)) {
                throw log.invalidContainerExtractorForType(this.extractorName, this.extractorClass, ((ExtractorResolutionState)state).extractedType);
            }
        }
    }

    private static interface ExtractorContributor {
        public boolean tryAppend(ExtractorResolutionState<?> var1);
    }
}

