/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryContext;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeTerminalContext;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.PropertyBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.IdentifierBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.PropertyBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.RoutingKeyBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.TypeBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.ValueBridgeBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.impl.BridgeResolver;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuildContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundPropertyBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundRoutingKeyBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundTypeBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundValueBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BridgeBuildContextImpl;
import org.hibernate.search.mapper.pojo.mapping.building.impl.FieldModelContributorBridgeContextImpl;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIdentifierBridgeToDocumentIdentifierValueConverter;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexModelBinder;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoValueBridgeToDocumentFieldValueConverter;
import org.hibernate.search.mapper.pojo.mapping.building.spi.FieldModelContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.dependency.impl.AbstractPojoBridgedElementDependencyContext;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoPropertyDependencyContextImpl;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoTypeDependencyContextImpl;
import org.hibernate.search.mapper.pojo.model.impl.AbstractPojoModelCompositeElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelPropertyRootElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelTypeRootElement;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelValueElement;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.util.impl.GenericTypeContext;
import org.hibernate.search.mapper.pojo.util.impl.ReflectionUtils;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexModelBinderImpl
implements PojoIndexModelBinder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BridgeBuildContext bridgeBuildContext;
    private final PojoBootstrapIntrospector introspector;
    private final ContainerExtractorBinder extractorBinder;
    private final BridgeResolver bridgeResolver;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;

    PojoIndexModelBinderImpl(MappingBuildContext buildContext, PojoBootstrapIntrospector introspector, ContainerExtractorBinder extractorBinder, BridgeResolver bridgeResolver, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider) {
        this.bridgeBuildContext = new BridgeBuildContextImpl(buildContext);
        this.introspector = introspector;
        this.extractorBinder = extractorBinder;
        this.bridgeResolver = bridgeResolver;
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
    }

    @Override
    public <C> BoundContainerExtractorPath<C, ?> bindExtractorPath(PojoGenericTypeModel<C> pojoGenericTypeModel, ContainerExtractorPath extractorPath) {
        return this.extractorBinder.bindPath(pojoGenericTypeModel, extractorPath);
    }

    @Override
    public <C, V> ContainerExtractorHolder<C, V> createExtractors(BoundContainerExtractorPath<C, V> boundExtractorPath) {
        return this.extractorBinder.create(boundExtractorPath);
    }

    @Override
    public <I> BeanHolder<? extends IdentifierBridge<I>> addIdentifierBridge(IndexedEntityBindingContext bindingContext, BoundPojoModelPathPropertyNode<?, I> modelPath, BridgeBuilder<? extends IdentifierBridge<?>> builder) {
        PojoGenericTypeModel<I> typeModel = modelPath.valueWithoutExtractors().getTypeModel();
        BridgeBuilder<IdentifierBridge<?>> defaultedBuilder = builder;
        if (builder == null) {
            defaultedBuilder = this.bridgeResolver.resolveIdentifierBridgeForType(typeModel);
        }
        BeanHolder<? extends IdentifierBridge<?>> bridgeHolder = defaultedBuilder.build(this.bridgeBuildContext);
        try {
            IdentifierBridge bridge = (IdentifierBridge)bridgeHolder.get();
            bridge.bind(new IdentifierBridgeBindingContextImpl<I>(new PojoModelValueElement<I>(typeModel)));
            bindingContext.idDslConverter(new PojoIdentifierBridgeToDocumentIdentifierValueConverter(bridge));
            return bridgeHolder;
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(holder -> ((IdentifierBridge)holder.get()).close(), bridgeHolder)).push(BeanHolder::close, bridgeHolder);
            throw e;
        }
    }

    @Override
    public <T> BoundRoutingKeyBridge<T> addRoutingKeyBridge(IndexedEntityBindingContext bindingContext, BoundPojoModelPathTypeNode<T> modelPath, BridgeBuilder<? extends RoutingKeyBridge> builder) {
        BeanHolder<? extends RoutingKeyBridge> bridgeHolder = builder.build(this.bridgeBuildContext);
        try {
            PojoModelTypeRootElement<T> pojoModelRootElement = new PojoModelTypeRootElement<T>(modelPath, this.typeAdditionalMetadataProvider);
            PojoTypeDependencyContextImpl<T> pojoDependencyContext = new PojoTypeDependencyContextImpl<T>(this.introspector, this.extractorBinder, this.typeAdditionalMetadataProvider, modelPath.getTypeModel());
            ((RoutingKeyBridge)bridgeHolder.get()).bind(new RoutingKeyBridgeBindingContextImpl(pojoModelRootElement, pojoDependencyContext));
            bindingContext.explicitRouting();
            this.checkBridgeDependencies(pojoModelRootElement, pojoDependencyContext);
            return new BoundRoutingKeyBridge<T>(bridgeHolder, pojoModelRootElement, pojoDependencyContext);
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(holder -> ((RoutingKeyBridge)holder.get()).close(), bridgeHolder)).push(BeanHolder::close, bridgeHolder);
            throw e;
        }
    }

    @Override
    public <T> Optional<BoundTypeBridge<T>> addTypeBridge(IndexBindingContext bindingContext, BoundPojoModelPathTypeNode<T> modelPath, BridgeBuilder<? extends TypeBridge> builder) {
        BeanHolder<? extends TypeBridge> bridgeHolder = builder.build(this.bridgeBuildContext);
        try {
            PojoIndexSchemaContributionListener listener = new PojoIndexSchemaContributionListener();
            PojoModelTypeRootElement<T> pojoModelRootElement = new PojoModelTypeRootElement<T>(modelPath, this.typeAdditionalMetadataProvider);
            PojoTypeDependencyContextImpl<T> pojoDependencyContext = new PojoTypeDependencyContextImpl<T>(this.introspector, this.extractorBinder, this.typeAdditionalMetadataProvider, modelPath.getTypeModel());
            ((TypeBridge)bridgeHolder.get()).bind(new TypeBridgeBindingContextImpl(pojoModelRootElement, pojoDependencyContext, bindingContext.createTypeFactory(), bindingContext.getSchemaElement((IndexSchemaContributionListener)listener)));
            this.checkBridgeDependencies(pojoModelRootElement, pojoDependencyContext);
            if (listener.schemaContributed) {
                return Optional.of(new BoundTypeBridge<T>(bridgeHolder, pojoModelRootElement, pojoDependencyContext));
            }
            try (Closer closer = new Closer();){
                closer.push(holder -> ((TypeBridge)holder.get()).close(), bridgeHolder);
                closer.push(BeanHolder::close, bridgeHolder);
            }
            return Optional.empty();
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(holder -> ((TypeBridge)holder.get()).close(), bridgeHolder)).push(BeanHolder::close, bridgeHolder);
            throw e;
        }
    }

    @Override
    public <P> Optional<BoundPropertyBridge<P>> addPropertyBridge(IndexBindingContext bindingContext, BoundPojoModelPathPropertyNode<?, P> modelPath, BridgeBuilder<? extends PropertyBridge> builder) {
        BeanHolder<? extends PropertyBridge> bridgeHolder = builder.build(this.bridgeBuildContext);
        try {
            PojoIndexSchemaContributionListener listener = new PojoIndexSchemaContributionListener();
            PojoModelPropertyRootElement<P> pojoModelRootElement = new PojoModelPropertyRootElement<P>(modelPath, this.typeAdditionalMetadataProvider);
            PojoPropertyDependencyContextImpl<P> pojoDependencyContext = new PojoPropertyDependencyContextImpl<P>(this.introspector, this.extractorBinder, this.typeAdditionalMetadataProvider, modelPath);
            ((PropertyBridge)bridgeHolder.get()).bind(new PropertyBridgeBindingContextImpl(pojoModelRootElement, pojoDependencyContext, bindingContext.createTypeFactory(), bindingContext.getSchemaElement((IndexSchemaContributionListener)listener)));
            this.checkBridgeDependencies(pojoModelRootElement, pojoDependencyContext);
            if (listener.schemaContributed) {
                return Optional.of(new BoundPropertyBridge<P>(bridgeHolder, pojoModelRootElement, pojoDependencyContext));
            }
            try (Closer closer = new Closer();){
                closer.push(holder -> ((PropertyBridge)holder.get()).close(), bridgeHolder);
                closer.push(BeanHolder::close, bridgeHolder);
            }
            return Optional.empty();
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(holder -> ((PropertyBridge)holder.get()).close(), bridgeHolder)).push(BeanHolder::close, bridgeHolder);
            throw e;
        }
    }

    @Override
    public <V> Optional<BoundValueBridge<V, ?>> addValueBridge(IndexBindingContext bindingContext, BoundPojoModelPathValueNode<?, ?, V> modelPath, boolean multiValued, BridgeBuilder<? extends ValueBridge<?, ?>> builder, String relativeFieldName, FieldModelContributor contributor) {
        Integer decimalScale = this.typeAdditionalMetadataProvider.get(modelPath).getDecimalScale();
        IndexFieldTypeDefaultsProvider defaultsProvider = new IndexFieldTypeDefaultsProvider(decimalScale);
        PojoGenericTypeModel<V> valueTypeModel = modelPath.getTypeModel();
        BridgeBuilder<ValueBridge<?, ?>> defaultedBuilder = builder;
        if (builder == null) {
            defaultedBuilder = this.bridgeResolver.resolveValueBridgeForType(valueTypeModel);
        }
        BeanHolder<? extends ValueBridge<?, ?>> bridgeHolder = defaultedBuilder.build(this.bridgeBuildContext);
        try {
            PojoIndexSchemaContributionListener listener = new PojoIndexSchemaContributionListener();
            IndexSchemaElement schemaElement = bindingContext.getSchemaElement((IndexSchemaContributionListener)listener);
            BoundValueBridge<V, ?> boundValueBridge = this.bindValueBridge(bindingContext.createTypeFactory(defaultsProvider), schemaElement, valueTypeModel, multiValued, bridgeHolder, relativeFieldName, contributor);
            if (listener.schemaContributed) {
                return Optional.of(boundValueBridge);
            }
            try (Closer closer = new Closer();){
                closer.push(holder -> ((ValueBridge)holder.get()).close(), bridgeHolder);
                closer.push(BeanHolder::close, bridgeHolder);
            }
            return Optional.empty();
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(holder -> ((ValueBridge)holder.get()).close(), bridgeHolder)).push(BeanHolder::close, bridgeHolder);
            throw e;
        }
    }

    private <V, V2, F, B extends ValueBridge<V2, F>> BoundValueBridge<V, ?> bindValueBridge(IndexFieldTypeFactoryContext indexFieldTypeFactory, IndexSchemaElement schemaElement, PojoGenericTypeModel<V> valueTypeModel, boolean multiValued, BeanHolder<? extends B> bridgeHolder, String relativeFieldName, FieldModelContributor contributor) {
        ValueBridge bridge = (ValueBridge)bridgeHolder.get();
        GenericTypeContext bridgeTypeContext = new GenericTypeContext(((ValueBridge)bridgeHolder.get()).getClass());
        Class bridgeParameterType = bridgeTypeContext.resolveTypeArgument(ValueBridge.class, 0).map(ReflectionUtils::getRawType).orElseThrow(() -> log.unableToInferValueBridgeInputType(bridge));
        if (!valueTypeModel.getRawType().isSubTypeOf(bridgeParameterType)) {
            throw log.invalidInputTypeForValueBridge(bridge, valueTypeModel);
        }
        PojoGenericTypeModel<V> castedValueTypeModel = valueTypeModel;
        BeanHolder<? extends B> castedBridgeHolder = bridgeHolder;
        ValueBridgeBindingContextImpl<V> bridgeBindingContext = new ValueBridgeBindingContextImpl<V>(new PojoModelValueElement<V>(castedValueTypeModel), indexFieldTypeFactory);
        StandardIndexFieldTypeContext fieldTypeContext = bridge.bind(bridgeBindingContext);
        if (fieldTypeContext == null) {
            Class returnType = bridgeTypeContext.resolveTypeArgument(ValueBridge.class, 1).map(ReflectionUtils::getRawType).orElseThrow(() -> log.unableToInferValueBridgeIndexFieldType(bridge));
            fieldTypeContext = indexFieldTypeFactory.as(returnType);
        }
        fieldTypeContext.dslConverter(new PojoValueBridgeToDocumentFieldValueConverter(bridge));
        contributor.contribute(fieldTypeContext, new FieldModelContributorBridgeContextImpl(bridge, fieldTypeContext));
        IndexSchemaFieldContext fieldContext = schemaElement.field(relativeFieldName, (IndexFieldTypeTerminalContext)fieldTypeContext);
        if (multiValued) {
            fieldContext.multiValued();
        }
        IndexFieldReference indexFieldReference = (IndexFieldReference)fieldContext.toReference();
        return new BoundValueBridge(castedBridgeHolder, indexFieldReference);
    }

    private void checkBridgeDependencies(AbstractPojoModelCompositeElement<?> pojoModelRootElement, AbstractPojoBridgedElementDependencyContext pojoDependencyContext) {
        boolean hasNonRootDependency;
        boolean isUseRootOnly = pojoDependencyContext.isUseRootOnly();
        boolean hasDependency = pojoModelRootElement.hasDependency() || pojoDependencyContext.hasNonRootDependency();
        boolean bl = hasNonRootDependency = pojoModelRootElement.hasNonRootDependency() || pojoDependencyContext.hasNonRootDependency();
        if (isUseRootOnly && hasNonRootDependency) {
            throw log.inconsistentBridgeDependencyDeclaration();
        }
        if (!isUseRootOnly && !hasDependency) {
            throw log.missingBridgeDependencyDeclaration();
        }
    }

    private class PojoIndexSchemaContributionListener
    implements IndexSchemaContributionListener {
        private boolean schemaContributed = false;

        private PojoIndexSchemaContributionListener() {
        }

        public void onSchemaContributed() {
            this.schemaContributed = true;
        }
    }
}

