/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexManagerBuildingState;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingContext;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.RoutingKeyBridge;
import org.hibernate.search.mapper.pojo.bridge.mapping.BridgeBuilder;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.dirtiness.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.BoundRoutingKeyBridge;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.impl.IdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PropertyIdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.impl.RoutingKeyBridgeRoutingKeyProvider;
import org.hibernate.search.mapper.pojo.mapping.impl.RoutingKeyProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilterFactory;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoIndexedTypeManagerBuilder<E, D extends DocumentElement> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoRawTypeModel<E> typeModel;
    private final PojoTypeAdditionalMetadata typeAdditionalMetadata;
    private final PojoMappingHelper mappingHelper;
    private final IndexManagerBuildingState<D> indexManagerBuildingState;
    private final PojoIdentityMappingCollectorImpl identityMappingCollector;
    private final PojoIndexingProcessorTypeNodeBuilder<E> processorBuilder;
    private PojoIndexingProcessor<E> preBuiltIndexingProcessor;
    private boolean closed = false;

    PojoIndexedTypeManagerBuilder(PojoRawTypeModel<E> typeModel, PojoTypeAdditionalMetadata typeAdditionalMetadata, PojoMappingHelper mappingHelper, IndexManagerBuildingState<D> indexManagerBuildingState, IdentifierMapping<?, E> defaultIdentifierMapping) {
        this.typeModel = typeModel;
        this.typeAdditionalMetadata = typeAdditionalMetadata;
        this.mappingHelper = mappingHelper;
        this.indexManagerBuildingState = indexManagerBuildingState;
        this.identityMappingCollector = new PojoIdentityMappingCollectorImpl(defaultIdentifierMapping);
        IndexedEntityBindingContext bindingContext = indexManagerBuildingState.getIndexedEntityBindingContext();
        this.processorBuilder = new PojoIndexingProcessorTypeNodeBuilder<E>(BoundPojoModelPath.root(typeModel), mappingHelper, (IndexBindingContext)bindingContext, Optional.of(this.identityMappingCollector), Collections.emptyList());
    }

    void closeOnFailure() {
        if (this.closed) {
            return;
        }
        try (Closer closer = new Closer();){
            closer.push(PojoIndexingProcessorTypeNodeBuilder::closeOnFailure, this.processorBuilder);
            closer.push(PojoIdentityMappingCollectorImpl::closeOnFailure, (Object)this.identityMappingCollector);
            closer.push(PojoIndexingProcessor::close, this.preBuiltIndexingProcessor);
            this.closed = true;
        }
    }

    PojoMappingCollectorTypeNode asCollector() {
        return this.processorBuilder;
    }

    void preBuild(PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        if (this.preBuiltIndexingProcessor != null) {
            throw new AssertionFailure("Internal error - preBuild should be called only once");
        }
        PojoIndexingDependencyCollectorTypeNode<E> dependencyCollector = reindexingResolverBuildingHelper.createDependencyCollector(this.typeModel);
        this.preBuiltIndexingProcessor = this.processorBuilder.build(dependencyCollector).orElseGet(PojoIndexingProcessor::noOp);
    }

    void buildAndAddTo(PojoIndexedTypeManagerContainer.Builder typeManagersBuilder, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper, PojoTypeAdditionalMetadata typeAdditionalMetadata) {
        RoutingKeyProvider routingKeyProvider;
        if (this.preBuiltIndexingProcessor == null) {
            throw new AssertionFailure("Internal error - preBuild should be called before buildAndAddTo");
        }
        IdentifierMapping identifierMapping = this.identityMappingCollector.identifierMapping;
        if (identifierMapping == null) {
            Optional<BoundPojoModelPathPropertyNode<E, ?>> entityIdPathOptional = this.getEntityIdentifierPath();
            if (entityIdPathOptional.isPresent()) {
                BoundPojoModelPathPropertyNode<E, ?> entityIdPath = entityIdPathOptional.get();
                this.identityMappingCollector.defaultIdentifierBridge(entityIdPath);
                identifierMapping = this.identityMappingCollector.identifierMapping;
            } else {
                throw log.missingIdentifierMapping(this.typeModel);
            }
        }
        if ((routingKeyProvider = this.identityMappingCollector.routingKeyProvider) == null) {
            routingKeyProvider = RoutingKeyProvider.alwaysNull();
        }
        PojoPathFilterFactory<Set<String>> pathFilterFactory = typeAdditionalMetadata.getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(this.typeModel)).getPathFilterFactory();
        Optional<PojoImplicitReindexingResolver<E, Set<String>>> reindexingResolverOptional = reindexingResolverBuildingHelper.build(this.typeModel, pathFilterFactory);
        PojoIndexedTypeManager typeManager = new PojoIndexedTypeManager(this.typeModel.getJavaClass(), this.typeModel.getCaster(), identifierMapping, routingKeyProvider, this.preBuiltIndexingProcessor, this.indexManagerBuildingState.build(), reindexingResolverOptional.orElseGet(PojoImplicitReindexingResolver::noOp));
        log.createdPojoIndexedTypeManager(typeManager);
        typeManagersBuilder.add(this.indexManagerBuildingState.getIndexName(), this.typeModel, typeManager);
        this.closed = true;
    }

    private Optional<BoundPojoModelPathPropertyNode<E, ?>> getEntityIdentifierPath() {
        Optional<String> entityIdPropertyName = this.typeAdditionalMetadata.getEntityTypeMetadata().orElseThrow(() -> log.missingEntityTypeMetadata(this.typeModel)).getEntityIdPropertyName();
        if (entityIdPropertyName.isPresent()) {
            return Optional.of(BoundPojoModelPath.root(this.typeModel).property(entityIdPropertyName.get()));
        }
        return Optional.empty();
    }

    private class PojoIdentityMappingCollectorImpl
    implements PojoIdentityMappingCollector {
        private IdentifierMapping<?, E> identifierMapping;
        private RoutingKeyBridgeRoutingKeyProvider<E> routingKeyProvider;

        PojoIdentityMappingCollectorImpl(IdentifierMapping<?, E> identifierMapping) {
            this.identifierMapping = identifierMapping;
        }

        void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.push(IdentifierMapping::close, this.identifierMapping);
                closer.push(RoutingKeyBridgeRoutingKeyProvider::close, this.routingKeyProvider);
            }
        }

        @Override
        public <T> void identifierBridge(BoundPojoModelPathPropertyNode<?, T> modelPath, BridgeBuilder<? extends IdentifierBridge<?>> builder) {
            BeanHolder<IdentifierBridge<T>> bridgeHolder = PojoIndexedTypeManagerBuilder.this.mappingHelper.getIndexModelBinder().addIdentifierBridge(PojoIndexedTypeManagerBuilder.this.indexManagerBuildingState.getIndexedEntityBindingContext(), modelPath, builder);
            PojoPropertyModel<T> propertyModel = modelPath.getPropertyModel();
            this.identifierMapping = new PropertyIdentifierMapping(propertyModel.getTypeModel().getRawType().getCaster(), propertyModel.getHandle(), bridgeHolder);
        }

        @Override
        public <T> BoundRoutingKeyBridge<T> routingKeyBridge(BoundPojoModelPathTypeNode<T> modelPath, BridgeBuilder<? extends RoutingKeyBridge> builder) {
            BoundRoutingKeyBridge<T> boundRoutingKeyBridge = PojoIndexedTypeManagerBuilder.this.mappingHelper.getIndexModelBinder().addRoutingKeyBridge(PojoIndexedTypeManagerBuilder.this.indexManagerBuildingState.getIndexedEntityBindingContext(), modelPath, builder);
            this.routingKeyProvider = new RoutingKeyBridgeRoutingKeyProvider(boundRoutingKeyBridge.getBridgeHolder());
            return boundRoutingKeyBridge;
        }

        <T> void defaultIdentifierBridge(BoundPojoModelPathPropertyNode<?, T> entityIdPath) {
            this.identifierBridge(entityIdPath, null);
        }
    }
}

