/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.programmatic.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeContext;
import org.hibernate.search.mapper.pojo.mapping.building.spi.FieldModelContributor;
import org.hibernate.search.mapper.pojo.mapping.building.spi.FieldModelContributorBridgeContext;

class PojoCompositeFieldModelContributor<C extends StandardIndexFieldTypeContext<?, ?>>
implements FieldModelContributor {
    private final Function<StandardIndexFieldTypeContext<?, ?>, C> contextConverter;
    private final List<BiConsumer<C, FieldModelContributorBridgeContext>> delegates = new ArrayList<BiConsumer<C, FieldModelContributorBridgeContext>>();

    PojoCompositeFieldModelContributor(Function<StandardIndexFieldTypeContext<?, ?>, C> contextConverter) {
        this.contextConverter = contextConverter;
    }

    public void add(BiConsumer<C, FieldModelContributorBridgeContext> delegate) {
        this.delegates.add(delegate);
    }

    @Override
    public void contribute(StandardIndexFieldTypeContext<?, ?> context, FieldModelContributorBridgeContext bridgeContext) {
        StandardIndexFieldTypeContext convertedContext = (StandardIndexFieldTypeContext)this.contextConverter.apply(context);
        this.delegates.forEach(c -> c.accept(convertedContext, bridgeContext));
    }
}

