/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.index.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexSearchScopeBuilder;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.dirtiness.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.mapping.impl.CachingCastingEntitySupplier;
import org.hibernate.search.mapper.pojo.mapping.impl.IdentifierMapping;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoDocumentContributor;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoDocumentReferenceProvider;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeWorkPlan;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoTypeDocumentWorkExecutor;
import org.hibernate.search.mapper.pojo.mapping.impl.RoutingKeyProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeAppendable;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexedTypeManager<I, E, D extends DocumentElement>
implements AutoCloseable,
ToStringTreeAppendable {
    private final Class<E> indexedJavaClass;
    private final PojoCaster<E> caster;
    private final IdentifierMapping<I, E> identifierMapping;
    private final RoutingKeyProvider<E> routingKeyProvider;
    private final PojoIndexingProcessor<E> processor;
    private final MappedIndexManager<D> indexManager;
    private final PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver;

    public PojoIndexedTypeManager(Class<E> indexedJavaClass, PojoCaster<E> caster, IdentifierMapping<I, E> identifierMapping, RoutingKeyProvider<E> routingKeyProvider, PojoIndexingProcessor<E> processor, MappedIndexManager<D> indexManager, PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver) {
        this.indexedJavaClass = indexedJavaClass;
        this.caster = caster;
        this.identifierMapping = identifierMapping;
        this.routingKeyProvider = routingKeyProvider;
        this.processor = processor;
        this.indexManager = indexManager;
        this.reindexingResolver = reindexingResolver;
    }

    public String toString() {
        return new ToStringTreeBuilder().value((Object)this).toString();
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierMapping::close, this.identifierMapping);
            closer.push(RoutingKeyProvider::close, this.routingKeyProvider);
            closer.push(PojoIndexingProcessor::close, this.processor);
            closer.push(PojoImplicitReindexingResolver::close, this.reindexingResolver);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("indexedJavaClass", this.indexedJavaClass).attribute("indexManager", this.indexManager).attribute("identifierMapping", this.identifierMapping).attribute("routingKeyProvider", this.routingKeyProvider).attribute("processor", this.processor).attribute("reindexingResolver", this.reindexingResolver);
    }

    public PojoTypeDocumentWorkExecutor<I, E, D> createDocumentWorkExecutor(AbstractPojoSessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy) {
        return new PojoTypeDocumentWorkExecutor(this, sessionContext, this.indexManager.createDocumentWorkExecutor((SessionContextImplementor)sessionContext, commitStrategy));
    }

    public IndexWorkExecutor createWorkExecutor() {
        return this.indexManager.createWorkExecutor();
    }

    IdentifierMapping<I, E> getIdentifierMapping() {
        return this.identifierMapping;
    }

    Class<E> getIndexedJavaClass() {
        return this.indexedJavaClass;
    }

    Supplier<E> toEntitySupplier(AbstractPojoSessionContextImplementor sessionContext, Object entity) {
        PojoRuntimeIntrospector introspector = sessionContext.getRuntimeIntrospector();
        return new CachingCastingEntitySupplier<E>(this.caster, introspector, entity);
    }

    DocumentReferenceProvider toDocumentReferenceProvider(AbstractPojoSessionContextImplementor sessionContext, I identifier, Supplier<E> entitySupplier) {
        String documentIdentifier = this.identifierMapping.toDocumentIdentifier(identifier, sessionContext.getMappingContext());
        return new PojoDocumentReferenceProvider<E>(this.routingKeyProvider, sessionContext, identifier, documentIdentifier, entitySupplier);
    }

    PojoDocumentContributor<D, E> toDocumentContributor(Supplier<E> entitySupplier, AbstractPojoSessionContextImplementor sessionContext) {
        return new PojoDocumentContributor(this.processor, sessionContext, entitySupplier);
    }

    boolean requiresSelfReindexing(Set<String> dirtyPaths) {
        return this.reindexingResolver.requiresSelfReindexing(dirtyPaths);
    }

    void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoRuntimeIntrospector runtimeIntrospector, Supplier<E> entitySupplier, Set<String> dirtyPaths) {
        this.reindexingResolver.resolveEntitiesToReindex(collector, runtimeIntrospector, entitySupplier.get(), dirtyPaths);
    }

    PojoIndexedTypeWorkPlan<I, E, D> createWorkPlan(AbstractPojoSessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return new PojoIndexedTypeWorkPlan(this, sessionContext, this.indexManager.createWorkPlan((SessionContextImplementor)sessionContext, commitStrategy, refreshStrategy));
    }

    <R, E2> MappedIndexSearchScopeBuilder<R, E2> createSearchScopeBuilder(MappingContextImplementor mappingContext) {
        return this.indexManager.createSearchScopeBuilder(mappingContext);
    }

    void addTo(MappedIndexSearchScopeBuilder<?, ?> builder) {
        this.indexManager.addTo(builder);
    }
}

